/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.diff;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.utils.AOMUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class TerminologyDifferentiator {
    public void differentiate(Archetype result) {
        this.removeAdditionalTranslations(result);
        this.differentiateTermDefinitions(result);
        this.differentiateTermBindings(result);
        this.differentiateValueSets(result);
        this.removeTerminologyExtracts(result);
    }

    private void removeAdditionalTranslations(Archetype result) {
        ArrayList<String> translationsToRemove = new ArrayList<String>();
        for (String key : result.getTerminology().getTermDefinitions().keySet()) {
            if (result.getTranslations().containsKey(key) || result.getTerminology().getOriginalLanguage().equals(key)) continue;
            translationsToRemove.add(key);
        }
        for (String key : translationsToRemove) {
            result.getTerminology().getTermDefinitions().remove(key);
        }
    }

    private void removeTerminologyExtracts(Archetype result) {
        result.getTerminology().getTerminologyExtracts().clear();
    }

    private void differentiateTermBindings(Archetype result) {
        Map termBindings = result.getTerminology().getTermBindings();
        HashSet<String> termBindingSetsToRemove = new HashSet<String>();
        for (String bindingKey : termBindings.keySet()) {
            Map bindings = (Map)termBindings.get(bindingKey);
            HashSet<String> termBindingsToRemove = new HashSet<String>();
            for (String termCode : bindings.keySet()) {
                if (AOMUtils.getSpecializationDepthFromCode((String)termCode) >= result.specializationDepth()) continue;
                termBindingsToRemove.add(termCode);
            }
            for (String termCode : termBindingsToRemove) {
                bindings.remove(termCode);
            }
            if (!bindings.isEmpty()) continue;
            termBindingSetsToRemove.add(bindingKey);
        }
        for (String bindingKey : termBindingSetsToRemove) {
            termBindings.remove(bindingKey);
        }
    }

    private void differentiateValueSets(Archetype result) {
        Map valueSets = result.getTerminology().getValueSets();
        HashSet<String> valueSetsToRemove = new HashSet<String>();
        for (String valueSetCode : valueSets.keySet()) {
            if (AOMUtils.getSpecializationDepthFromCode((String)valueSetCode) >= result.specializationDepth()) continue;
            valueSetsToRemove.add(valueSetCode);
        }
        for (String valueSetCode : valueSetsToRemove) {
            valueSets.remove(valueSetCode);
        }
    }

    private void differentiateTermDefinitions(Archetype result) {
        Map termDefinitions = result.getTerminology().getTermDefinitions();
        HashSet<String> languagesToRemove = new HashSet<String>();
        for (String language : termDefinitions.keySet()) {
            Map terms = (Map)termDefinitions.get(language);
            HashSet<String> termsToDelete = new HashSet<String>();
            for (String termCode : terms.keySet()) {
                if (AOMUtils.getSpecializationDepthFromCode((String)termCode) >= result.specializationDepth()) continue;
                termsToDelete.add(termCode);
            }
            for (String term : termsToDelete) {
                terms.remove(term);
            }
            if (!terms.isEmpty()) continue;
            languagesToRemove.add(language);
        }
        for (String language : languagesToRemove) {
            termDefinitions.remove(language);
        }
    }
}

