/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import java.util.HashMap;
import org.openehr.utils.message.I18n;

public class NodeIdValidation
extends ValidatingVisitor {
    private HashMap<String, String> nodeIds = new HashMap();

    @Override
    protected void beginValidation() {
        this.nodeIds.clear();
    }

    @Override
    public void validate(CObject cObject) {
        int archetypeSpecialisationDepth = this.archetype.specializationDepth();
        if (cObject.getNodeId() == null) {
            this.addMessageWithPath(ErrorType.VCOID, cObject.getPath(), I18n.t((String)"C_OBJECT with RM type {0} must have a node id", (Object[])new Object[]{cObject.getRmTypeName()}));
        } else if (!"id9999".equals(cObject.getNodeId()) && archetypeSpecialisationDepth == AOMUtils.getSpecializationDepthFromCode((String)cObject.getNodeId()) && this.nodeIds.containsKey(cObject.getNodeId())) {
            this.addMessageWithPath(ErrorType.VCOSU, cObject.getPath(), I18n.t((String)"Node id {0} already used in path {1}", (Object[])new Object[]{cObject.getNodeId(), this.nodeIds.get(cObject.getNodeId())}));
        }
        this.nodeIds.put(cObject.getNodeId(), cObject.getPath());
    }
}

