/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ArchetypeValidationBase;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.query.AOMPathQuery;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openehr.utils.message.I18n;

public class BasicTerminologyValidation
extends ArchetypeValidationBase {
    @Override
    public void validate() {
        this.validateFormatAndSpecializationLevelOfCodes();
        this.validateLanguageConsistency();
        this.validateTerminologyBindings();
        this.validateValueSets();
        this.warnAboutUnusedValues();
    }

    private void validateFormatAndSpecializationLevelOfCodes() {
        int terminologySpecialisationDepth = this.archetype.getTerminology().specialisationDepth();
        for (Map languageSpecificTerminology : this.archetype.getTerminology().getTermDefinitions().values()) {
            for (ArchetypeTerm term : languageSpecificTerminology.values()) {
                if (!AOMUtils.isValidCode((String)term.getCode())) {
                    this.addMessage(ErrorType.VATCV, I18n.t((String)"Id code {0} in terminology is not a valid term code, should be id, ac or at, followed by digits", (Object[])new Object[]{term.getCode()}));
                }
                if (this.archetype.isDifferential()) {
                    if (terminologySpecialisationDepth == AOMUtils.getSpecializationDepthFromCode((String)term.getCode())) continue;
                    this.addMessage(ErrorType.VTSD, I18n.t((String)"Id code {0} in terminology is of a different specialization depth than the archetype", (Object[])new Object[]{term.getCode()}));
                    continue;
                }
                if (AOMUtils.getSpecializationDepthFromCode((String)term.getCode()) <= terminologySpecialisationDepth) continue;
                this.addMessage(ErrorType.VTSD, I18n.t((String)"Id code {0} in terminology is of a different specialization depth than the archetype", (Object[])new Object[]{term.getCode()}));
            }
        }
    }

    public void validateLanguageConsistency() {
        List codes = this.archetype.getTerminology().allCodes();
        for (String code : codes) {
            for (String language : this.archetype.getTerminology().getTermDefinitions().keySet()) {
                if (((Map)this.archetype.getTerminology().getTermDefinitions().get(language)).containsKey(code)) continue;
                this.addMessage(ErrorType.VTLC, "code " + code + " is not present in language " + language);
            }
        }
    }

    private void validateTerminologyBindings() {
        ArchetypeTerminology terminology = this.archetype.getTerminology();
        Map termBindings = terminology.getTermBindings();
        if (termBindings != null) {
            for (String terminologyId : termBindings.keySet()) {
                if (termBindings.get(terminologyId) == null) continue;
                for (String constraintCodeOrPath : ((Map)termBindings.get(terminologyId)).keySet()) {
                    boolean archetypeHasPath = false;
                    try {
                        archetypeHasPath = !new AOMPathQuery(constraintCodeOrPath).findList(this.archetype.getDefinition()).isEmpty();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!(AOMUtils.isValidCode((String)constraintCodeOrPath) || archetypeHasPath || this.combinedModels.hasReferenceModelPath(this.archetype.getDefinition().getRmTypeName(), constraintCodeOrPath))) {
                        this.addMessage(ErrorType.VTTBK, I18n.t((String)"Term binding key {0} in path format is not present in archetype", (Object[])new Object[]{constraintCodeOrPath}));
                        continue;
                    }
                    if (!AOMUtils.isValidCode((String)constraintCodeOrPath) || terminology.hasCode(constraintCodeOrPath) || this.archetype.isSpecialized() && this.flatParent != null && !this.flatParent.getTerminology().hasCode(constraintCodeOrPath)) continue;
                    this.addMessage(ErrorType.VTTBK, I18n.t((String)"Term binding key {0} is not present in terminology", (Object[])new Object[]{constraintCodeOrPath}));
                }
            }
        }
    }

    private void validateValueSets() {
        ArchetypeTerminology terminology = this.archetype.getTerminology();
        for (ValueSet valueSet : terminology.getValueSets().values()) {
            if (!terminology.hasValueSetCode(valueSet.getId())) {
                this.addMessage(ErrorType.VTVSID, I18n.t((String)"value set code {0} is not present in terminology", (Object[])new Object[]{valueSet.getId()}));
            }
            for (String value : valueSet.getMembers()) {
                if (this.flatParent == null) {
                    if (terminology.hasValueCode(value)) continue;
                    this.addMessage(ErrorType.VTVSMD, I18n.t((String)"value code {0} is not present in terminology", (Object[])new Object[]{value}));
                    continue;
                }
                if (terminology.hasValueCode(value) || this.flatParent.getTerminology().hasValueCode(value)) continue;
                this.addMessage(ErrorType.VTVSMD, I18n.t((String)"value code {0} is not present in terminology", (Object[])new Object[]{value}));
            }
        }
    }

    private void warnAboutUnusedValues() {
        Set usedCodes = this.archetype.getAllUsedCodes();
        ArchetypeTerminology terminology = this.archetype.getTerminology();
        for (String language : terminology.getTermDefinitions().keySet()) {
            Map archetypeTerms = (Map)terminology.getTermDefinitions().get(language);
            for (String key : archetypeTerms.keySet()) {
                if (usedCodes.contains(key)) continue;
                this.addWarning(ErrorType.WOUC, I18n.t((String)"Code {0} is in the terminology, but not used in the archetype", (Object[])new Object[]{key}));
            }
        }
    }
}

