/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.archetypevalidator.ArchetypeValidationBase;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.validations.ValidationUtils;
import java.util.Objects;
import org.openehr.utils.message.I18n;

public class BasicChecks
extends ArchetypeValidationBase {
    @Override
    public void validate() {
        this.checkRmRootType();
        this.checkIdCodeSpecialisationLevel();
        this.checkMissingTerminology();
        this.checkSpecializationDepth();
    }

    private void checkSpecializationDepth() {
        int nodeIdSpecialisationDepth;
        int parentNodeIdSpecialisationDepth;
        Archetype parent;
        if (this.archetype.getParentArchetypeId() != null && (parent = this.repository.getArchetype(this.archetype.getParentArchetypeId())) != null && (parentNodeIdSpecialisationDepth = parent.getDefinition().specialisationDepth().intValue()) != (nodeIdSpecialisationDepth = this.archetype.getDefinition().specialisationDepth().intValue()) - 1) {
            this.addMessage(ErrorType.VACSD, I18n.t((String)"The specialisation depth of the archetype, {0}, must be one greater than the specialisation depth of the parent archetype, {1}", (Object[])new Object[]{nodeIdSpecialisationDepth, parentNodeIdSpecialisationDepth}));
        }
    }

    private void checkMissingTerminology() {
        if (this.archetype.getTerminology() == null) {
            this.addMessage(ErrorType.STCNT, I18n.t((String)"Archetype terminology not defined", (Object[])new Object[0]));
        } else if (this.archetype.getTerminology().getTermDefinitions() == null || this.archetype.getTerminology().getTermDefinitions().isEmpty()) {
            this.addMessage(ErrorType.STCNT, I18n.t((String)"Archetype terminology contains no term definitions", (Object[])new Object[0]));
        }
    }

    private void checkIdCodeSpecialisationLevel() {
        int depth = ValidationUtils.getSpecializationDepth(this.archetype, this.repository);
        if (depth != this.archetype.getDefinition().specialisationDepth()) {
            this.addMessageWithPath(ErrorType.VARCN, "/", I18n.t((String)"Incorrect root node id {0}: it must match the specialization depth of the archetype, which is {1}", (Object[])new Object[]{this.archetype.getDefinition().getNodeId(), depth}));
        }
        if (!this.archetype.getDefinition().getNodeId().matches("id1(\\.1)*")) {
            this.addMessageWithPath(ErrorType.VARCN, "/", I18n.t((String)"The node id is not in the form id1.1....1: {0}", (Object[])new Object[]{this.archetype.getDefinition().getNodeId()}));
        }
    }

    private void checkRmRootType() {
        if (!Objects.equals(this.archetype.getArchetypeId().getRmClass(), this.archetype.getDefinition().getRmTypeName())) {
            this.addMessage(ErrorType.VARDT, I18n.t((String)"RM type in id {0} does not match RM type in definition {1}", (Object[])new Object[]{this.archetype.getArchetypeId().getConceptId(), this.archetype.getDefinition().getRmTypeName()}));
        }
    }
}

