/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.query;

import com.nedap.archie.query.APathToXPathConverter;
import com.nedap.archie.query.ArchieNamespaceResolver;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.UniqueNodePathBuilder;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RMQueryContext {
    private final XPathFactory xPathFactory;
    private final ModelInfoLookup modelInfoLooup;
    private Binder<Node> binder;
    private Document domForQueries;
    private Object rootNode;
    private String firstXPathNode;
    private static Logger logger = LoggerFactory.getLogger(RMQueryContext.class);

    public RMQueryContext(ModelInfoLookup lookup, Object rootNode, JAXBContext jaxbContext) {
        try {
            this.rootNode = rootNode;
            this.modelInfoLooup = lookup;
            this.binder = jaxbContext.createBinder();
            this.domForQueries = this.createBlankDOMDocument(true);
            this.binder.setProperty("jaxb.formatted.output", (Object)true);
            this.binder.marshal(rootNode, (Object)this.domForQueries);
            this.firstXPathNode = this.domForQueries.getFirstChild().getNodeName();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        this.xPathFactory = XPathFactory.newInstance();
    }

    public Document createBlankDOMDocument(boolean namespaceAware) {
        DocumentBuilder builder;
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(namespaceAware);
        try {
            builder = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return builder.newDocument();
    }

    public <T> List<T> findList(String query) throws XPathExpressionException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (query.equals("/")) {
            result.add(this.rootNode);
        } else {
            String convertedQuery = APathToXPathConverter.convertQueryToXPath(query, this.firstXPathNode);
            XPath xpath = this.xPathFactory.newXPath();
            xpath.setNamespaceContext(new ArchieNamespaceResolver(this.domForQueries));
            NodeList foundNodes = (NodeList)xpath.evaluate(convertedQuery, this.domForQueries, XPathConstants.NODESET);
            for (int i = 0; i < foundNodes.getLength(); ++i) {
                Node node = foundNodes.item(i);
                result.add(this.getJAXBNode(node));
            }
        }
        return result;
    }

    private <T> T getJAXBNode(Node node) {
        Object object = this.binder.getJAXBNode((Object)node);
        if (object != null) {
            return (T)object;
        }
        String nodeName = node.getNodeName();
        Object parent = this.binder.getJAXBNode((Object)node.getParentNode());
        if (parent == null) {
            logger.error("trying to get a node without a parent");
            return null;
        }
        RMAttributeInfo attributeInfo = this.modelInfoLooup.getAttributeInfo(parent.getClass(), nodeName);
        try {
            return (T)attributeInfo.getGetMethod().invoke(parent, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public Node getNode(Object object) {
        return (Node)this.binder.getXMLNode(object);
    }

    public String getUniquePath(Object object) {
        if (object == null) {
            return null;
        }
        Node node = this.getNode(object);
        if (node == null) {
            return null;
        }
        return UniqueNodePathBuilder.constructPath(node);
    }

    public List<RMObjectWithPath> findListWithPaths(String query) throws XPathExpressionException {
        String convertedQuery = APathToXPathConverter.convertQueryToXPath(query, this.firstXPathNode);
        XPath xpath = this.xPathFactory.newXPath();
        xpath.setNamespaceContext(new ArchieNamespaceResolver(this.domForQueries));
        NodeList foundNodes = (NodeList)xpath.evaluate(convertedQuery, this.domForQueries, XPathConstants.NODESET);
        ArrayList<RMObjectWithPath> result = new ArrayList<RMObjectWithPath>();
        for (int i = 0; i < foundNodes.getLength(); ++i) {
            Node node = foundNodes.item(i);
            String path = UniqueNodePathBuilder.constructPath(node);
            result.add(new RMObjectWithPath(this.getJAXBNode(node), path));
        }
        return result;
    }

    public <T> T find(String query) throws XPathExpressionException {
        List<T> result = this.findList(query);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        throw new RuntimeException("query returned more than one element: " + result.size());
    }

    public void updateValue(Object parent) throws JAXBException {
        this.binder.updateXML(parent);
    }
}

