/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.archetypevalidator.validations;

import com.nedap.archie.adlparser.modelconstraints.ReflectionConstraintImposer;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.archetypevalidator.ValidatingVisitor;
import com.nedap.archie.base.Interval;
import com.nedap.archie.rminfo.MetaModelInterface;
import org.openehr.utils.message.I18n;

public class ValidateAgainstReferenceModel
extends ValidatingVisitor {
    @Override
    protected void validate(CComplexObject cObject) {
        this.validateTypes((CObject)cObject);
    }

    private void validateTypes(CObject cObject) {
        if (!this.combinedModels.typeNameExists(cObject.getRmTypeName())) {
            this.addMessageWithPath(ErrorType.VCORM, cObject.getPath(), I18n.t((String)"Type name {0} does not exist", (Object[])new Object[]{cObject.getRmTypeName()}));
        } else {
            CAttribute owningAttribute = cObject.getParent();
            if (owningAttribute != null) {
                CObject owningObject = owningAttribute.getParent();
                if (owningAttribute.getDifferentialPath() != null && this.flatParent != null) {
                    CAttribute differentialPathFromParent = (CAttribute)AOMUtils.getDifferentialPathFromParent((Archetype)this.flatParent, (CAttribute)owningAttribute);
                    CObject cObject2 = owningObject = differentialPathFromParent == null ? null : differentialPathFromParent.getParent();
                }
                if (owningObject != null && !this.combinedModels.typeConformant(owningObject.getRmTypeName(), owningAttribute.getRmAttributeName(), cObject.getRmTypeName())) {
                    this.addMessageWithPath(ErrorType.VCORMT, cObject.getPath(), I18n.t((String)"Attribute {0}.{1} cannot contain type {2}", (Object[])new Object[]{owningObject.getRmTypeName(), owningAttribute.getRmAttributeName(), cObject.getRmTypeName()}));
                }
            }
        }
    }

    @Override
    protected void validate(CComplexObjectProxy cObject) {
        this.validateTypes((CObject)cObject);
    }

    @Override
    protected void validate(CPrimitiveObject cObject) {
        CAttribute parentAttribute;
        CObject parentConstraint;
        ArchetypeModelObject differentialPathFromParent;
        CAttribute attribute = cObject.getParent();
        if (attribute.getDifferentialPath() == null) {
            CObject parentConstraint2 = attribute.getParent();
            if (!this.combinedModels.validatePrimitiveType(parentConstraint2.getRmTypeName(), attribute.getRmAttributeName(), cObject)) {
                this.addMessageWithPath(ErrorType.VCORMT, cObject.path(), I18n.t((String)"Attribute {0}.{1} cannot be constrained by a {2}", (Object[])new Object[]{parentConstraint2.getRmTypeName(), attribute.getRmAttributeName(), cObject == null ? null : cObject.getClass().getSimpleName()}));
            }
        } else if (this.flatParent != null && (differentialPathFromParent = AOMUtils.getDifferentialPathFromParent((Archetype)this.flatParent, (CAttribute)attribute)) instanceof CAttribute && !this.combinedModels.validatePrimitiveType((parentConstraint = (parentAttribute = (CAttribute)differentialPathFromParent).getParent()).getRmTypeName(), parentAttribute.getRmAttributeName(), cObject)) {
            I18n.t((String)"Attribute {0}.{1} cannot be constrained by a {2}", (Object[])new Object[]{parentConstraint.getRmTypeName(), parentAttribute.getRmAttributeName(), cObject == null ? null : cObject.getClass().getSimpleName()});
        }
    }

    @Override
    public void validate(CAttribute cAttribute) {
        if (this.flatParent == null && cAttribute.getDifferentialPath() != null) {
            return;
        }
        CObject owningObject = cAttribute.getParent();
        if (cAttribute.getDifferentialPath() != null) {
            CAttribute differentialPathFromParent = (CAttribute)AOMUtils.getDifferentialPathFromParent((Archetype)this.flatParent, (CAttribute)cAttribute);
            CObject cObject = owningObject = differentialPathFromParent == null ? null : differentialPathFromParent.getParent();
        }
        if (owningObject != null) {
            if (!this.combinedModels.attributeExists(owningObject.getRmTypeName(), cAttribute.getRmAttributeName())) {
                this.addMessageWithPath(ErrorType.VCARM, cAttribute.getPath(), I18n.t((String)"{0} is not a known attribute of {1}", (Object[])new Object[]{cAttribute.getRmAttributeName(), owningObject.getRmTypeName()}));
            } else {
                CAttribute defaultAttribute = new ReflectionConstraintImposer((MetaModelInterface)this.combinedModels).getDefaultAttribute(owningObject.getRmTypeName(), cAttribute.getRmAttributeName());
                if (defaultAttribute != null) {
                    if (cAttribute.getExistence() != null && !defaultAttribute.getExistence().contains((Interval)cAttribute.getExistence()).booleanValue()) {
                        if (!this.archetype.isSpecialized() && defaultAttribute.getExistence().equals((Object)cAttribute.getExistence())) {
                            if (this.settings.isStrictMultiplicitiesSpecializationValidation()) {
                                this.addMessageWithPath(ErrorType.VCAEX, cAttribute.path(), I18n.t((String)"The existence of attribute {0}.{1} is the same as in the reference model - this is not allowed due to strict existence validation being enabled", (Object[])new Object[]{owningObject.getRmTypeName(), cAttribute.getRmAttributeName()}));
                            } else {
                                cAttribute.setExistence(null);
                            }
                        } else {
                            this.addMessageWithPath(ErrorType.VCAEX, cAttribute.path(), I18n.t((String)"The existence {0} of attribute {2}.{3} does not match existence {1} of the reference model", (Object[])new Object[]{cAttribute.getExistence(), defaultAttribute.getExistence(), owningObject.getRmTypeName(), cAttribute.getRmAttributeName()}));
                        }
                    }
                    if (defaultAttribute.isMultiple()) {
                        if (defaultAttribute.getCardinality() != null && cAttribute.getCardinality() != null && cAttribute.getCardinality().getInterval() != null && !defaultAttribute.getCardinality().contains(cAttribute.getCardinality()).booleanValue()) {
                            if (defaultAttribute.getCardinality().equals((Object)cAttribute.getCardinality())) {
                                if (this.settings.isStrictMultiplicitiesSpecializationValidation()) {
                                    this.addMessageWithPath(ErrorType.VCACA, cAttribute.path(), I18n.t((String)"The cardinality of Attribute {0}.{1} is the same as in the reference model - this is not allowed due to strict multiplicities validation being enabled", (Object[])new Object[]{owningObject.getRmTypeName(), cAttribute.getRmAttributeName()}));
                                } else {
                                    cAttribute.setCardinality(null);
                                }
                            } else {
                                this.addMessageWithPath(ErrorType.VCACA, cAttribute.path(), I18n.t((String)"The cardinality {0} of attribute {2}.{3} does not match cardinality {1} of the reference model", (Object[])new Object[]{cAttribute.getCardinality(), defaultAttribute.getCardinality(), owningObject.getRmTypeName(), cAttribute.getRmAttributeName()}));
                            }
                        }
                    } else if (cAttribute.getCardinality() != null) {
                        this.addMessageWithPath(ErrorType.VCAM, defaultAttribute.path(), I18n.t((String)"Single valued attributes can not have a cardinality", (Object[])new Object[0]));
                    }
                }
            }
        }
    }
}

