/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.base.terminology;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.nedap.archie.base.OpenEHRBase;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="TERMINOLOGY_CODE")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, defaultImpl=TerminologyCode.class)
public class TerminologyCode
extends OpenEHRBase {
    @XmlElement(name="terminology_id")
    private String terminologyId;
    @XmlElement(name="terminology_version")
    private String terminologyVersion;
    @XmlElement(name="code_string")
    private String codeString;
    private URI uri;

    @JsonCreator
    public static TerminologyCode createFromString(String terminologyString) {
        if (terminologyString.isEmpty()) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\[(?<terminologyId>[^\\(\\)]+)(\\((?<terminologyVersion>.+)\\))?::(?<codeString>.+)\\]");
        Matcher matcher = pattern.matcher(terminologyString);
        TerminologyCode result = new TerminologyCode();
        if (matcher.matches()) {
            result.setTerminologyId(matcher.group("terminologyId"));
            result.setCodeString(matcher.group("codeString"));
            result.setTerminologyVersion(matcher.group("terminologyVersion"));
        } else {
            result.setCodeString(terminologyString);
        }
        return result;
    }

    @JsonCreator
    public static TerminologyCode createFromString(@JsonProperty(value="terminology_id") String terminologyId, @JsonProperty(value="terminology_version") String terminologyVersion, @JsonProperty(value="code_string") String codeString) {
        TerminologyCode result = new TerminologyCode();
        result.terminologyId = terminologyId;
        result.terminologyVersion = terminologyVersion;
        result.codeString = codeString;
        return result;
    }

    public String getTerminologyVersion() {
        return this.terminologyVersion;
    }

    public void setTerminologyVersion(String terminologyVersion) {
        this.terminologyVersion = terminologyVersion;
    }

    public String getTerminologyIdString() {
        return this.getTerminologyId();
    }

    public String toString() {
        return this.terminologyVersion == null ? "[" + this.getTerminologyId() + "::" + this.getCodeString() + "]" : "[" + this.getTerminologyId() + "(" + this.terminologyVersion + ")::" + this.getCodeString() + "]";
    }

    public String getTerminologyId() {
        return this.terminologyId;
    }

    public void setTerminologyId(String terminologyId) {
        this.terminologyId = terminologyId;
    }

    public String getCodeString() {
        return this.codeString;
    }

    public void setCodeString(String codeString) {
        this.codeString = codeString;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

