/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.antlr.errors;

import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import java.util.BitSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchieErrorListener
implements ANTLRErrorListener {
    private boolean logEnabled = true;
    private static final Logger logger = LoggerFactory.getLogger(ArchieErrorListener.class);
    private final ANTLRParserErrors errors;

    public ArchieErrorListener() {
        this.errors = new ANTLRParserErrors();
    }

    public ArchieErrorListener(ANTLRParserErrors errors) {
        this.errors = errors;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        String error = String.format("syntax error at %d:%d: %s. msg: %s", line, charPositionInLine, offendingSymbol, msg);
        if (this.logEnabled) {
            logger.warn(error);
        }
        if (offendingSymbol != null) {
            String offendingSymbolString = offendingSymbol.toString();
            this.errors.addError(error, msg, line, charPositionInLine, offendingSymbolString.length(), offendingSymbolString);
        } else {
            this.errors.addError(error, msg, line, charPositionInLine);
        }
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        String input = recognizer.getInputStream().getText(new Interval(startIndex, stopIndex));
        String warning = String.format("FULL AMBIGUITY: %d-%d, exact: %b, input: %s", startIndex, stopIndex, exact, input);
        if (this.logEnabled) {
            logger.debug(warning);
        }
        this.errors.addWarning(warning);
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        String input = recognizer.getInputStream().getText(new Interval(startIndex, stopIndex));
        if (this.logEnabled) {
            logger.debug("FULL CONTEXT: {}-{}, alts: {}, {}", new Object[]{startIndex, stopIndex, conflictingAlts, input});
        }
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        if (this.logEnabled) {
            logger.debug("CONTEXT SENSITIVITY: {}-{}, prediction: {}", new Object[]{startIndex, stopIndex, prediction});
        }
    }

    public ANTLRParserErrors getErrors() {
        return this.errors;
    }
}

