package com.nedap.archie.definitions;

/*
 * #%L
 * OpenEHR - Java Model Stack
 * %%
 * Copyright (C) 2016 - 2017 Cognitive Medical Systems
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 * Author: Claude Nanjo
 */

/**
 * Defines globally used constant values.
 *
 * Created by cnanjo on 6/2/16.
 */
public class BasicDefinitions {
    /**
     * Carriage return character
     */
    public static final char CR = '\015';
    /**
     * Line feed character.
     */
    public static final char LF = '\012';

    public static final String ANY_TYPE = "Any";

    public static final String REGEX_ANY_PATTERN = ".*";

    public static final String DEFAULT_ENCODING = "UTF-8";

}

