/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.json;

import java.util.Objects;

public class RMJacksonConfiguration {
    private String typePropertyName = "@type";
    private boolean alwaysIncludeTypeProperty = true;
    private boolean addPathProperty = true;
    private boolean addExtraFieldsInArchetypeId = true;
    private boolean failOnUnknownProperties = false;
    private boolean serializeEmptyCollections = true;

    public static RMJacksonConfiguration createStandardsCompliant() {
        RMJacksonConfiguration configuration = new RMJacksonConfiguration();
        configuration.setTypePropertyName("_type");
        configuration.setAlwaysIncludeTypeProperty(false);
        configuration.setAddPathProperty(false);
        configuration.setAddExtraFieldsInArchetypeId(false);
        return configuration;
    }

    public static RMJacksonConfiguration createConfigForJavascriptUsage() {
        RMJacksonConfiguration configuration = new RMJacksonConfiguration();
        configuration.setTypePropertyName("_type");
        configuration.setAlwaysIncludeTypeProperty(true);
        configuration.setAddPathProperty(true);
        configuration.setAddExtraFieldsInArchetypeId(true);
        return configuration;
    }

    public String getTypePropertyName() {
        return this.typePropertyName;
    }

    public void setTypePropertyName(String typePropertyName) {
        this.typePropertyName = typePropertyName;
    }

    public boolean isAlwaysIncludeTypeProperty() {
        return this.alwaysIncludeTypeProperty;
    }

    public void setAlwaysIncludeTypeProperty(boolean alwaysIncludeTypeProperty) {
        this.alwaysIncludeTypeProperty = alwaysIncludeTypeProperty;
    }

    public boolean isAddPathProperty() {
        return this.addPathProperty;
    }

    public void setAddPathProperty(boolean addPathProperty) {
        this.addPathProperty = addPathProperty;
    }

    public boolean isAddExtraFieldsInArchetypeId() {
        return this.addExtraFieldsInArchetypeId;
    }

    public void setAddExtraFieldsInArchetypeId(boolean addExtraFieldsInArchetypeId) {
        this.addExtraFieldsInArchetypeId = addExtraFieldsInArchetypeId;
    }

    public boolean isFailOnUnknownProperties() {
        return this.failOnUnknownProperties;
    }

    public void setFailOnUnknownProperties(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public boolean isSerializeEmptyCollections() {
        return this.serializeEmptyCollections;
    }

    public void setSerializeEmptyCollections(boolean serializeEmptyCollections) {
        this.serializeEmptyCollections = serializeEmptyCollections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RMJacksonConfiguration)) {
            return false;
        }
        RMJacksonConfiguration that = (RMJacksonConfiguration)o;
        return this.alwaysIncludeTypeProperty == that.alwaysIncludeTypeProperty && this.addPathProperty == that.addPathProperty && this.addExtraFieldsInArchetypeId == that.addExtraFieldsInArchetypeId && this.failOnUnknownProperties == that.failOnUnknownProperties && this.serializeEmptyCollections == that.serializeEmptyCollections && Objects.equals(this.typePropertyName, that.typePropertyName);
    }

    public int hashCode() {
        return Objects.hash(this.typePropertyName, this.alwaysIncludeTypeProperty, this.addPathProperty, this.addExtraFieldsInArchetypeId, this.failOnUnknownProperties, this.serializeEmptyCollections);
    }
}

