/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.nedap.archie.json.JacksonUtil;
import com.nedap.archie.json.RMJacksonConfiguration;
import com.nedap.archie.odin.CodePhraseSerializer;
import com.nedap.archie.odin.OdinParsingClusterMixin;
import com.nedap.archie.odin.OdinParsingItemTreeMixin;
import com.nedap.archie.rm.datastructures.Cluster;
import com.nedap.archie.rm.datastructures.ItemTree;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rminfo.RMObjectMapperProvider;
import java.io.IOException;
import org.openehr.odin.jackson.ODINMapper;

public class ArchieRMObjectMapperProvider
implements RMObjectMapperProvider {
    public ObjectMapper getInputOdinObjectMapper() {
        ObjectMapper odinMapper = new ObjectMapper();
        JacksonUtil.configureObjectMapper(odinMapper);
        odinMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        odinMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        odinMapper.enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        odinMapper.disable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        SimpleModule odinRmSupport = new SimpleModule();
        odinRmSupport.setMixInAnnotation(Cluster.class, OdinParsingClusterMixin.class);
        odinRmSupport.setMixInAnnotation(ItemTree.class, OdinParsingItemTreeMixin.class);
        odinMapper.registerModule((Module)odinRmSupport);
        odinMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
                if (propertyName.equalsIgnoreCase("@type")) {
                    return true;
                }
                return super.handleUnknownProperty(ctxt, p, deserializer, beanOrClass, propertyName);
            }
        });
        return odinMapper;
    }

    public ObjectMapper getOutputOdinObjectMapper() {
        ODINMapper odinMapper = new ODINMapper();
        RMJacksonConfiguration config = RMJacksonConfiguration.createStandardsCompliant();
        config.setAlwaysIncludeTypeProperty(false);
        config.setSerializeEmptyCollections(false);
        JacksonUtil.configureObjectMapper((ObjectMapper)odinMapper, config);
        SimpleModule odinRmSupport = new SimpleModule();
        odinRmSupport.addSerializer(CodePhrase.class, (JsonSerializer)new CodePhraseSerializer());
        odinMapper.registerModule((Module)odinRmSupport);
        return odinMapper;
    }

    public ObjectMapper getJsonObjectMapper() {
        RMJacksonConfiguration config = RMJacksonConfiguration.createStandardsCompliant();
        config.setAlwaysIncludeTypeProperty(false);
        config.setSerializeEmptyCollections(false);
        return JacksonUtil.getObjectMapper(config);
    }
}

