/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

class PartialView
extends RelativeLayout {
    private ImageView mFilledView;
    private ImageView mEmptyView;
    private int mStarWidth = 0;
    private int mStarHeight = 0;

    public PartialView(Context context, int partialViewId, int starWidth, int startHeight, int padding) {
        super(context);
        this.mStarWidth = starWidth;
        this.mStarHeight = startHeight;
        this.setTag(partialViewId);
        this.setPadding(padding, padding, padding, padding);
        this.init();
    }

    public PartialView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PartialView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(this.mStarWidth == 0 ? -2 : this.mStarWidth, this.mStarHeight == 0 ? -2 : this.mStarHeight);
        this.mFilledView = new ImageView(this.getContext());
        this.mFilledView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.mFilledView, params);
        this.mEmptyView = new ImageView(this.getContext());
        this.mEmptyView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.mEmptyView, params);
        this.setEmpty();
    }

    public void setFilledDrawable(Drawable drawable2) {
        if (drawable2.getConstantState() == null) {
            return;
        }
        ClipDrawable clipDrawable = new ClipDrawable(drawable2.getConstantState().newDrawable(), 0x800003, 1);
        this.mFilledView.setImageDrawable((Drawable)clipDrawable);
    }

    public void setEmptyDrawable(Drawable drawable2) {
        if (drawable2.getConstantState() == null) {
            return;
        }
        ClipDrawable clipDrawable = new ClipDrawable(drawable2.getConstantState().newDrawable(), 0x800005, 1);
        this.mEmptyView.setImageDrawable((Drawable)clipDrawable);
    }

    public void setFilled() {
        this.mFilledView.setImageLevel(10000);
        this.mEmptyView.setImageLevel(0);
    }

    public void setPartialFilled(float rating) {
        float percentage = rating % 1.0f;
        int level = (int)(10000.0f * percentage);
        level = level == 0 ? 10000 : level;
        this.mFilledView.setImageLevel(level);
        this.mEmptyView.setImageLevel(10000 - level);
    }

    public void setEmpty() {
        this.mFilledView.setImageLevel(0);
        this.mEmptyView.setImageLevel(10000);
    }

    public void setStarWidth(@IntRange(from=0L) int starWidth) {
        this.mStarWidth = starWidth;
        ViewGroup.LayoutParams params = this.mFilledView.getLayoutParams();
        params.width = this.mStarWidth;
        this.mFilledView.setLayoutParams(params);
        this.mEmptyView.setLayoutParams(params);
    }

    public void setStarHeight(@IntRange(from=0L) int starHeight) {
        this.mStarHeight = starHeight;
        ViewGroup.LayoutParams params = this.mFilledView.getLayoutParams();
        params.height = this.mStarHeight;
        this.mFilledView.setLayoutParams(params);
        this.mEmptyView.setLayoutParams(params);
    }
}

