/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.willy.ratingbar.AnimationRatingBar;
import com.willy.ratingbar.PartialView;
import com.willy.ratingbar.R;

public class ScaleRatingBar
extends AnimationRatingBar {
    public ScaleRatingBar(Context context) {
        super(context);
    }

    public ScaleRatingBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ScaleRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void emptyRatingBar() {
        this.mDelay = 0;
        this.mStopFillingFlag = true;
        for (final PartialView view : this.mPartialViews) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    view.setEmpty();
                }
            }, (long)(this.mDelay += 5));
        }
    }

    @Override
    protected void fillRatingBar(final float rating) {
        this.mDelay = 0;
        this.mStopFillingFlag = false;
        for (final PartialView partialView : this.mPartialViews) {
            double maxIntOfRating;
            final int ratingViewId = (Integer)partialView.getTag();
            if ((double)ratingViewId > (maxIntOfRating = Math.ceil(rating))) {
                partialView.setEmpty();
                continue;
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ScaleRatingBar.this.mStopFillingFlag) {
                        return;
                    }
                    if ((double)ratingViewId == maxIntOfRating) {
                        partialView.setPartialFilled(rating);
                    } else {
                        partialView.setFilled();
                    }
                    if ((float)ratingViewId == rating) {
                        Animation scaleUp = AnimationUtils.loadAnimation((Context)ScaleRatingBar.this.getContext(), (int)R.anim.scale_up);
                        Animation scaleDown = AnimationUtils.loadAnimation((Context)ScaleRatingBar.this.getContext(), (int)R.anim.scale_down);
                        partialView.startAnimation(scaleUp);
                        partialView.startAnimation(scaleDown);
                    }
                }
            }, (long)(this.mDelay += 15));
        }
    }
}

