/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

public class PartialView
extends RelativeLayout {
    private ImageView mFilledView;
    private ImageView mEmptyView;

    public PartialView(Context context) {
        super(context);
        this.init();
    }

    public PartialView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PartialView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mFilledView = new ImageView(this.getContext());
        this.mFilledView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mEmptyView = new ImageView(this.getContext());
        this.mEmptyView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.mFilledView);
        this.addView((View)this.mEmptyView);
        this.setEmpty();
    }

    public void setFilledDrawable(Drawable drawable2) {
        if (drawable2.getConstantState() == null) {
            return;
        }
        ClipDrawable clipDrawable = new ClipDrawable(drawable2.getConstantState().newDrawable(), 0x800003, 1);
        this.mFilledView.setImageDrawable((Drawable)clipDrawable);
    }

    public void setEmptyDrawable(Drawable drawable2) {
        if (drawable2.getConstantState() == null) {
            return;
        }
        ClipDrawable clipDrawable = new ClipDrawable(drawable2.getConstantState().newDrawable(), 0x800005, 1);
        this.mEmptyView.setImageDrawable((Drawable)clipDrawable);
    }

    public void setFilled() {
        this.mFilledView.setImageLevel(10000);
        this.mEmptyView.setImageLevel(0);
    }

    public void setPartialFilled(float rating) {
        float percentage = rating % 1.0f;
        int level = (int)(10000.0f * percentage);
        level = level == 0 ? 10000 : level;
        this.mFilledView.setImageLevel(level);
        this.mEmptyView.setImageLevel(10000 - level);
    }

    public void setEmpty() {
        this.mFilledView.setImageLevel(0);
        this.mEmptyView.setImageLevel(10000);
    }
}

