/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.willy.ratingbar.R;
import com.willy.ratingbar.SimpleRatingBar;
import java.util.LinkedHashMap;
import java.util.Map;

public class BaseRatingBar
extends LinearLayout
implements SimpleRatingBar {
    protected int mNumStars = 5;
    protected int mRating = 0;
    protected int mPadding = 20;
    protected Drawable mEmptyDrawable;
    protected Drawable mFilledDrawable;
    protected Map<ImageView, Boolean> mRatingViewStatus;

    public BaseRatingBar(Context context) {
        this(context, null);
    }

    public BaseRatingBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBarAttributes);
        this.mNumStars = typedArray.getInt(R.styleable.RatingBarAttributes_numStars, this.mNumStars);
        this.mPadding = typedArray.getInt(R.styleable.RatingBarAttributes_starPadding, this.mPadding);
        this.mRating = typedArray.getInt(R.styleable.RatingBarAttributes_rating, this.mRating);
        this.mEmptyDrawable = typedArray.getDrawable(R.styleable.RatingBarAttributes_drawableEmpty);
        this.mFilledDrawable = typedArray.getDrawable(R.styleable.RatingBarAttributes_drawableFilled);
        typedArray.recycle();
        if (this.mEmptyDrawable == null) {
            this.mEmptyDrawable = this.getResources().getDrawable(R.drawable.start_empty);
        }
        if (this.mFilledDrawable == null) {
            this.mFilledDrawable = this.getResources().getDrawable(R.drawable.star_filled);
        }
        this.initRatingView();
    }

    private void initRatingView() {
        this.mRatingViewStatus = new LinkedHashMap<ImageView, Boolean>();
        for (int i = 1; i <= this.mNumStars; ++i) {
            ImageView ratingView;
            if (i <= this.mRating) {
                ratingView = this.getRatingView(i, this.mFilledDrawable);
                this.mRatingViewStatus.put(ratingView, true);
            } else {
                ratingView = this.getRatingView(i, this.mEmptyDrawable);
                this.mRatingViewStatus.put(ratingView, false);
            }
            this.addView((View)ratingView);
        }
        this.setRating(this.mRating);
    }

    private ImageView getRatingView(int ratingViewId, Drawable drawable2) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setId(ratingViewId);
        imageView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        imageView.setImageDrawable(drawable2);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int rating = v.getId();
                if (BaseRatingBar.this.mRating == rating) {
                    BaseRatingBar.this.clearRating();
                    return;
                }
                BaseRatingBar.this.setRating(rating);
            }
        });
        return imageView;
    }

    private void removeAllRatingViews() {
        this.mRatingViewStatus.clear();
        this.removeAllViews();
    }

    protected void clearRating() {
        this.mRating = 0;
        if (this.mRatingViewStatus.size() <= 0) {
            return;
        }
        for (ImageView view : this.mRatingViewStatus.keySet()) {
            view.setImageDrawable(this.mEmptyDrawable);
            this.mRatingViewStatus.put(view, false);
        }
    }

    protected void fillRatingBar(int rating) {
        for (ImageView view : this.mRatingViewStatus.keySet()) {
            if (view.getId() <= rating) {
                view.setImageDrawable(this.mFilledDrawable);
                this.mRatingViewStatus.put(view, true);
                continue;
            }
            view.setImageDrawable(this.mEmptyDrawable);
            this.mRatingViewStatus.put(view, false);
        }
    }

    @Override
    public void setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.removeAllRatingViews();
        this.mNumStars = numStars;
        this.initRatingView();
    }

    @Override
    public int getNumStars() {
        return this.mNumStars;
    }

    @Override
    public void setRating(int rating) {
        if (rating > this.mNumStars) {
            rating = this.mNumStars;
        }
        if (rating < 0) {
            rating = 0;
        }
        if (this.mRating == rating) {
            return;
        }
        this.mRating = rating;
        this.fillRatingBar(rating);
    }

    @Override
    public int getRating() {
        return this.mRating;
    }

    @Override
    public void setStarPadding(int ratingPadding) {
        this.mPadding = ratingPadding;
        for (ImageView view : this.mRatingViewStatus.keySet()) {
            view.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        }
    }

    @Override
    public int getStarPadding() {
        return this.mPadding;
    }

    @Override
    public void setEmptyDrawable(Drawable drawable2) {
        this.mEmptyDrawable = drawable2;
        for (ImageView view : this.mRatingViewStatus.keySet()) {
            if (this.mRatingViewStatus.get(view).booleanValue()) continue;
            view.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setFilledDrawable(Drawable drawable2) {
        this.mFilledDrawable = drawable2;
        for (ImageView view : this.mRatingViewStatus.keySet()) {
            if (!this.mRatingViewStatus.get(view).booleanValue()) continue;
            view.setImageDrawable(drawable2);
        }
    }
}

