/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import com.willy.ratingbar.BaseRatingBar;
import com.willy.ratingbar.R;

public class ScaleRatingBar
extends BaseRatingBar {
    public static final String TAG = "SimpleRatingBar";

    public ScaleRatingBar(Context context) {
        super(context);
    }

    public ScaleRatingBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ScaleRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void clearRating() {
        this.mRating = 0;
        if (this.mRatingViewStatus.size() <= 0) {
            return;
        }
        int delay = 0;
        for (final ImageView view : this.mRatingViewStatus.keySet()) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    view.setImageDrawable(ScaleRatingBar.this.mEmptyDrawable);
                    ScaleRatingBar.this.mRatingViewStatus.put(view, false);
                }
            }, (long)(delay += 5));
        }
    }

    @Override
    protected void fillRatingBar(final int rating) {
        int delay = 0;
        for (final ImageView view : this.mRatingViewStatus.keySet()) {
            if (view.getId() <= rating) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        view.setImageDrawable(ScaleRatingBar.this.mFilledDrawable);
                        ScaleRatingBar.this.mRatingViewStatus.put(view, true);
                        if (view.getId() == rating) {
                            Animation scaleUp = AnimationUtils.loadAnimation((Context)ScaleRatingBar.this.getContext(), (int)R.anim.scale_up);
                            Animation scaleDown = AnimationUtils.loadAnimation((Context)ScaleRatingBar.this.getContext(), (int)R.anim.scale_down);
                            view.startAnimation(scaleUp);
                            view.startAnimation(scaleDown);
                        }
                    }
                }, (long)(delay += 15));
                continue;
            }
            view.setImageDrawable(this.mEmptyDrawable);
            this.mRatingViewStatus.put(view, false);
        }
    }
}

