/*
 * Decompiled with CFR 0.152.
 */
package com.willy.ratingbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import com.willy.ratingbar.BaseRatingBar;
import com.willy.ratingbar.R;
import java.util.LinkedHashMap;

public class SimpleRatingBar
extends BaseRatingBar {
    public static final String TAG = "SimpleRatingBar";

    public SimpleRatingBar(Context context) {
        super(context);
    }

    public SimpleRatingBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SimpleRatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        super.init();
        this.initRatingViews();
    }

    private void initRatingViews() {
        this.mRatingViewStatus = new LinkedHashMap();
        for (int i = 1; i <= this.mNumStars; ++i) {
            ImageView ratingView;
            if (i <= this.mRating) {
                ratingView = this.getRatingView(i, this.mFilledDrawable);
                this.mRatingViewStatus.put(ratingView, true);
            } else {
                ratingView = this.getRatingView(i, this.mEmptyDrawable);
                this.mRatingViewStatus.put(ratingView, false);
            }
            this.addView((View)ratingView);
        }
    }

    private ImageView getRatingView(int ratingViewId, Drawable drawable2) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setId(ratingViewId);
        imageView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        imageView.setImageDrawable(drawable2);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int rating = v.getId();
                if (SimpleRatingBar.this.mRating == rating) {
                    SimpleRatingBar.this.clearRatingBar();
                    return;
                }
                SimpleRatingBar.this.setRating(rating);
            }
        });
        return imageView;
    }

    private void clearRatingBar() {
        this.mRating = 0;
        if (this.mRatingViewStatus.size() <= 0) {
            return;
        }
        int delay = 0;
        for (final ImageView view : this.mRatingViewStatus.keySet()) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    view.setImageDrawable(SimpleRatingBar.this.mEmptyDrawable);
                    SimpleRatingBar.this.mRatingViewStatus.put(view, false);
                }
            }, (long)(delay += 5));
        }
    }

    @Override
    protected void fillRatingBar(final int rating) {
        int delay = 0;
        for (final ImageView view : this.mRatingViewStatus.keySet()) {
            if (view.getId() <= rating) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        view.setImageDrawable(SimpleRatingBar.this.mFilledDrawable);
                        SimpleRatingBar.this.mRatingViewStatus.put(view, true);
                        if (view.getId() == rating) {
                            Animation scaleUp = AnimationUtils.loadAnimation((Context)SimpleRatingBar.this.getContext(), (int)R.anim.scale_up);
                            Animation scaleDown = AnimationUtils.loadAnimation((Context)SimpleRatingBar.this.getContext(), (int)R.anim.scale_down);
                            view.startAnimation(scaleUp);
                            view.startAnimation(scaleDown);
                        }
                    }
                }, (long)(delay += 15));
                continue;
            }
            view.setImageDrawable(this.mEmptyDrawable);
            this.mRatingViewStatus.put(view, false);
        }
    }
}

