/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.ScrollingView;
import com.github.nukc.stateview.StateView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/github/nukc/stateview/Injector;", "", "()V", "constraintLayoutAvailable", "", "getConstraintLayoutAvailable", "()Z", "matchViewIfParentIsConstraintLayout", "Lcom/github/nukc/stateview/StateView;", "parent", "Landroidx/constraintlayout/widget/ConstraintLayout;", "view", "Landroid/view/View;", "matchViewIfParentIsRelativeLayout", "Landroid/widget/RelativeLayout;", "setStateListAnimator", "", "stateView", "target", "wrapChild", "Landroid/view/ViewGroup;", "kotlin_release"})
public final class Injector {
    private static final boolean constraintLayoutAvailable;
    public static final Injector INSTANCE;

    public final boolean getConstraintLayoutAvailable() {
        return constraintLayoutAvailable;
    }

    @NotNull
    public final StateView wrapChild(@NotNull ViewGroup parent) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        int screenHeight = 0;
        FrameLayout wrapper = new FrameLayout(parent.getContext());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        wrapper.setLayoutParams(layoutParams);
        if (parent instanceof LinearLayout) {
            LinearLayout wrapLayout = new LinearLayout(((LinearLayout)parent).getContext());
            ViewGroup.LayoutParams layoutParams2 = ((LinearLayout)parent).getLayoutParams();
            if (layoutParams2 == null) {
                layoutParams2 = layoutParams;
            }
            wrapLayout.setLayoutParams(layoutParams2);
            wrapLayout.setOrientation(((LinearLayout)parent).getOrientation());
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView;
                Intrinsics.checkExpressionValueIsNotNull((Object)parent.getChildAt(0), (String)"parent.getChildAt(0)");
                parent.removeView(childView);
                wrapLayout.addView(childView);
            }
            wrapper.addView((View)wrapLayout);
        } else if (parent instanceof ScrollView || parent instanceof ScrollingView) {
            if (parent.getChildCount() != 1) {
                throw (Throwable)new IllegalStateException("the ScrollView does not have one direct child");
            }
            View directView = parent.getChildAt(0);
            parent.removeView(directView);
            wrapper.addView(directView);
            Object object = parent.getContext().getSystemService("window");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager wm = (WindowManager)object;
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            screenHeight = metrics.heightPixels;
        } else if (parent instanceof NestedScrollingParent && parent instanceof NestedScrollingChild) {
            if (parent.getChildCount() == 2) {
                View targetView = parent.getChildAt(1);
                parent.removeView(targetView);
                wrapper.addView(targetView);
            } else if (parent.getChildCount() > 2) {
                throw (Throwable)new IllegalStateException("the view is not refresh layout? view = " + parent);
            }
        } else {
            throw (Throwable)new IllegalStateException("the view does not have parent, view = " + parent);
        }
        parent.addView((View)wrapper);
        Context context = parent.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"parent.context");
        StateView stateView = new StateView(context);
        if (screenHeight > 0) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, screenHeight);
            wrapper.addView((View)stateView, params);
        } else {
            wrapper.addView((View)stateView);
        }
        return stateView;
    }

    @NotNull
    public final StateView matchViewIfParentIsConstraintLayout(@NotNull ConstraintLayout parent, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = parent.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"parent.context");
        StateView stateView = new StateView(context);
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(layoutParams);
        lp.leftToLeft = view.getId();
        lp.rightToRight = view.getId();
        lp.topToTop = view.getId();
        lp.bottomToBottom = view.getId();
        parent.addView((View)stateView, (ViewGroup.LayoutParams)lp);
        return stateView;
    }

    @NotNull
    public final StateView matchViewIfParentIsRelativeLayout(@NotNull RelativeLayout parent, @NotNull View view) {
        RelativeLayout.LayoutParams layoutParams;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = parent.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"parent.context");
        StateView stateView = new StateView(context);
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams layoutParams2 = view.getLayoutParams();
            if (layoutParams2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
            }
            layoutParams = new RelativeLayout.LayoutParams((RelativeLayout.LayoutParams)layoutParams2);
        } else {
            layoutParams = new RelativeLayout.LayoutParams(view.getLayoutParams());
        }
        RelativeLayout.LayoutParams lp = layoutParams;
        parent.addView((View)stateView, (ViewGroup.LayoutParams)lp);
        this.setStateListAnimator(stateView, view);
        return stateView;
    }

    public final void setStateListAnimator(@NotNull StateView stateView, @NotNull View target) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateView), (String)"stateView");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (Build.VERSION.SDK_INT >= 21 && target instanceof Button) {
            Log.i((String)StateView.Companion.getTAG$kotlin_release(), (String)"for normal display, stateView.stateListAnimator = view.stateListAnimator");
            stateView.setStateListAnimator(((Button)target).getStateListAnimator());
        }
    }

    private Injector() {
    }

    static {
        boolean bl;
        Injector injector;
        INSTANCE = injector = new Injector();
        try {
            bl = Class.forName("androidx.constraintlayout.widget.ConstraintLayout") != null;
        }
        catch (Throwable e) {
            bl = false;
        }
        constraintLayoutAvailable = bl;
    }
}

