/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.socketio.client;

import com.github.nkzawa.backo.Backoff;
import com.github.nkzawa.emitter.Emitter;
import com.github.nkzawa.engineio.client.Socket;
import com.github.nkzawa.socketio.client.On;
import com.github.nkzawa.socketio.client.Socket;
import com.github.nkzawa.socketio.client.SocketIOException;
import com.github.nkzawa.socketio.parser.Packet;
import com.github.nkzawa.socketio.parser.Parser;
import com.github.nkzawa.thread.EventThread;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class Manager
extends Emitter {
    private static final Logger logger = Logger.getLogger(Manager.class.getName());
    public static final String EVENT_OPEN = "open";
    public static final String EVENT_CLOSE = "close";
    public static final String EVENT_PACKET = "packet";
    public static final String EVENT_ERROR = "error";
    public static final String EVENT_CONNECT_ERROR = "connect_error";
    public static final String EVENT_CONNECT_TIMEOUT = "connect_timeout";
    public static final String EVENT_RECONNECT = "reconnect";
    public static final String EVENT_RECONNECT_ERROR = "reconnect_error";
    public static final String EVENT_RECONNECT_FAILED = "reconnect_failed";
    public static final String EVENT_RECONNECT_ATTEMPT = "reconnect_attempt";
    public static final String EVENT_RECONNECTING = "reconnecting";
    public static final String EVENT_TRANSPORT = "transport";
    static SSLContext defaultSSLContext;
    static HostnameVerifier defaultHostnameVerifier;
    ReadyState readyState = null;
    private boolean _reconnection;
    private boolean skipReconnect;
    private boolean reconnecting;
    private boolean encoding;
    private int _reconnectionAttempts;
    private long _reconnectionDelay;
    private long _reconnectionDelayMax;
    private double _randomizationFactor;
    private Backoff backoff;
    private long _timeout;
    private Set<Socket> connected;
    private URI uri;
    private List<Packet> packetBuffer;
    private Queue<On.Handle> subs;
    private Options opts;
    com.github.nkzawa.engineio.client.Socket engine;
    private Parser.Encoder encoder;
    private Parser.Decoder decoder;
    private ConcurrentHashMap<String, Socket> nsps;

    public Manager() {
        this(null, null);
    }

    public Manager(URI uri) {
        this(uri, null);
    }

    public Manager(Options opts) {
        this(null, opts);
    }

    public Manager(URI uri, Options opts) {
        if (opts == null) {
            opts = new Options();
        }
        if (opts.path == null) {
            opts.path = "/socket.io";
        }
        if (opts.sslContext == null) {
            opts.sslContext = defaultSSLContext;
        }
        if (opts.hostnameVerifier == null) {
            opts.hostnameVerifier = defaultHostnameVerifier;
        }
        this.opts = opts;
        this.nsps = new ConcurrentHashMap();
        this.subs = new LinkedList<On.Handle>();
        this.reconnection(opts.reconnection);
        this.reconnectionAttempts(opts.reconnectionAttempts != 0 ? opts.reconnectionAttempts : Integer.MAX_VALUE);
        this.reconnectionDelay(opts.reconnectionDelay != 0L ? opts.reconnectionDelay : 1000L);
        this.reconnectionDelayMax(opts.reconnectionDelayMax != 0L ? opts.reconnectionDelayMax : 5000L);
        this.randomizationFactor(opts.randomizationFactor != 0.0 ? opts.randomizationFactor : 0.5);
        this.backoff = new Backoff().setMin(this.reconnectionDelay()).setMax(this.reconnectionDelayMax()).setJitter(this.randomizationFactor());
        this.timeout(opts.timeout);
        this.readyState = ReadyState.CLOSED;
        this.uri = uri;
        this.connected = new HashSet<Socket>();
        this.encoding = false;
        this.packetBuffer = new ArrayList<Packet>();
        this.encoder = new Parser.Encoder();
        this.decoder = new Parser.Decoder();
    }

    private void emitAll(String event, Object ... args) {
        this.emit(event, args);
        for (Socket socket : this.nsps.values()) {
            socket.emit(event, args);
        }
    }

    private void updateSocketIds() {
        for (Socket socket : this.nsps.values()) {
            socket.id = this.engine.id();
        }
    }

    public boolean reconnection() {
        return this._reconnection;
    }

    public Manager reconnection(boolean v) {
        this._reconnection = v;
        return this;
    }

    public int reconnectionAttempts() {
        return this._reconnectionAttempts;
    }

    public Manager reconnectionAttempts(int v) {
        this._reconnectionAttempts = v;
        return this;
    }

    public long reconnectionDelay() {
        return this._reconnectionDelay;
    }

    public Manager reconnectionDelay(long v) {
        this._reconnectionDelay = v;
        if (this.backoff != null) {
            this.backoff.setMin(v);
        }
        return this;
    }

    public double randomizationFactor() {
        return this._randomizationFactor;
    }

    public Manager randomizationFactor(double v) {
        this._randomizationFactor = v;
        if (this.backoff != null) {
            this.backoff.setJitter(v);
        }
        return this;
    }

    public long reconnectionDelayMax() {
        return this._reconnectionDelayMax;
    }

    public Manager reconnectionDelayMax(long v) {
        this._reconnectionDelayMax = v;
        if (this.backoff != null) {
            this.backoff.setMax(v);
        }
        return this;
    }

    public long timeout() {
        return this._timeout;
    }

    public Manager timeout(long v) {
        this._timeout = v;
        return this;
    }

    private void maybeReconnectOnOpen() {
        if (!this.reconnecting && this._reconnection && this.backoff.getAttempts() == 0) {
            this.reconnect();
        }
    }

    public Manager open() {
        return this.open(null);
    }

    public Manager open(final OpenCallback fn) {
        EventThread.exec((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.fine(String.format("readyState %s", new Object[]{Manager.this.readyState}));
                if (Manager.this.readyState == ReadyState.OPEN || Manager.this.readyState == ReadyState.OPENING) {
                    return;
                }
                logger.fine(String.format("opening %s", Manager.this.uri));
                final com.github.nkzawa.engineio.client.Socket socket = Manager.this.engine = new Engine(Manager.this.uri, Manager.this.opts);
                final Manager self = Manager.this;
                Manager.this.readyState = ReadyState.OPENING;
                Manager.this.skipReconnect = false;
                socket.on(Manager.EVENT_TRANSPORT, new Emitter.Listener(){

                    public void call(Object ... args) {
                        self.emit(Manager.EVENT_TRANSPORT, args);
                    }
                });
                final On.Handle openSub = On.on((Emitter)socket, Manager.EVENT_OPEN, new Emitter.Listener(){

                    public void call(Object ... objects) {
                        self.onopen();
                        if (fn != null) {
                            fn.call(null);
                        }
                    }
                });
                On.Handle errorSub = On.on((Emitter)socket, Manager.EVENT_ERROR, new Emitter.Listener(){

                    public void call(Object ... objects) {
                        Object data = objects.length > 0 ? objects[0] : null;
                        logger.fine(Manager.EVENT_CONNECT_ERROR);
                        self.cleanup();
                        self.readyState = ReadyState.CLOSED;
                        self.emitAll(Manager.EVENT_CONNECT_ERROR, new Object[]{data});
                        if (fn != null) {
                            SocketIOException err = new SocketIOException("Connection error", data instanceof Exception ? (Exception)data : null);
                            fn.call(err);
                        } else {
                            self.maybeReconnectOnOpen();
                        }
                    }
                });
                if (Manager.this._timeout >= 0L) {
                    final long timeout = Manager.this._timeout;
                    logger.fine(String.format("connection attempt will timeout after %d", timeout));
                    final Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            EventThread.exec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    logger.fine(String.format("connect attempt timed out after %d", timeout));
                                    openSub.destroy();
                                    socket.close();
                                    socket.emit(Manager.EVENT_ERROR, new Object[]{new SocketIOException("timeout")});
                                    self.emitAll(Manager.EVENT_CONNECT_TIMEOUT, new Object[]{timeout});
                                }
                            });
                        }
                    }, timeout);
                    Manager.this.subs.add(new On.Handle(){

                        @Override
                        public void destroy() {
                            timer.cancel();
                        }
                    });
                }
                Manager.this.subs.add(openSub);
                Manager.this.subs.add(errorSub);
                Manager.this.engine.open();
            }
        });
        return this;
    }

    private void onopen() {
        logger.fine(EVENT_OPEN);
        this.cleanup();
        this.readyState = ReadyState.OPEN;
        this.emit(EVENT_OPEN, new Object[0]);
        com.github.nkzawa.engineio.client.Socket socket = this.engine;
        this.subs.add(On.on((Emitter)socket, "data", new Emitter.Listener(){

            public void call(Object ... objects) {
                Object data = objects[0];
                if (data instanceof String) {
                    Manager.this.ondata((String)data);
                } else if (data instanceof byte[]) {
                    Manager.this.ondata((byte[])data);
                }
            }
        }));
        this.subs.add(On.on(this.decoder, Parser.Decoder.EVENT_DECODED, new Emitter.Listener(){

            public void call(Object ... objects) {
                Manager.this.ondecoded((Packet)objects[0]);
            }
        }));
        this.subs.add(On.on((Emitter)socket, EVENT_ERROR, new Emitter.Listener(){

            public void call(Object ... objects) {
                Manager.this.onerror((Exception)objects[0]);
            }
        }));
        this.subs.add(On.on((Emitter)socket, EVENT_CLOSE, new Emitter.Listener(){

            public void call(Object ... objects) {
                Manager.this.onclose((String)objects[0]);
            }
        }));
    }

    private void ondata(String data) {
        this.decoder.add(data);
    }

    private void ondata(byte[] data) {
        this.decoder.add(data);
    }

    private void ondecoded(Packet packet) {
        this.emit(EVENT_PACKET, new Object[]{packet});
    }

    private void onerror(Exception err) {
        logger.log(Level.FINE, EVENT_ERROR, err);
        this.emitAll(EVENT_ERROR, err);
    }

    public Socket socket(String nsp) {
        Socket socket = this.nsps.get(nsp);
        if (socket == null) {
            socket = new Socket(this, nsp);
            Socket _socket = this.nsps.putIfAbsent(nsp, socket);
            if (_socket != null) {
                socket = _socket;
            } else {
                final Manager self = this;
                final Socket s = socket;
                socket.on("connect", new Emitter.Listener(){

                    public void call(Object ... objects) {
                        s.id = self.engine.id();
                        self.connected.add(s);
                    }
                });
            }
        }
        return socket;
    }

    void destroy(Socket socket) {
        this.connected.remove((Object)socket);
        if (this.connected.size() > 0) {
            return;
        }
        this.close();
    }

    void packet(Packet packet) {
        logger.fine(String.format("writing packet %s", packet));
        final Manager self = this;
        if (!self.encoding) {
            self.encoding = true;
            this.encoder.encode(packet, new Parser.Encoder.Callback(){

                @Override
                public void call(Object[] encodedPackets) {
                    for (Object packet : encodedPackets) {
                        if (packet instanceof String) {
                            self.engine.write((String)packet);
                            continue;
                        }
                        if (!(packet instanceof byte[])) continue;
                        self.engine.write((byte[])packet);
                    }
                    self.encoding = false;
                    self.processPacketQueue();
                }
            });
        } else {
            self.packetBuffer.add(packet);
        }
    }

    private void processPacketQueue() {
        if (this.packetBuffer.size() > 0 && !this.encoding) {
            Packet pack = this.packetBuffer.remove(0);
            this.packet(pack);
        }
    }

    private void cleanup() {
        On.Handle sub;
        while ((sub = this.subs.poll()) != null) {
            sub.destroy();
        }
    }

    void close() {
        if (this.readyState != ReadyState.OPEN) {
            this.cleanup();
        }
        this.skipReconnect = true;
        this.backoff.reset();
        this.readyState = ReadyState.CLOSED;
        if (this.engine != null) {
            this.engine.close();
        }
    }

    private void onclose(String reason) {
        logger.fine(EVENT_CLOSE);
        this.cleanup();
        this.backoff.reset();
        this.readyState = ReadyState.CLOSED;
        this.emit(EVENT_CLOSE, new Object[]{reason});
        if (this._reconnection && !this.skipReconnect) {
            this.reconnect();
        }
    }

    private void reconnect() {
        if (this.reconnecting || this.skipReconnect) {
            return;
        }
        final Manager self = this;
        if (this.backoff.getAttempts() >= this._reconnectionAttempts) {
            logger.fine("reconnect failed");
            this.backoff.reset();
            this.emitAll(EVENT_RECONNECT_FAILED, new Object[0]);
            this.reconnecting = false;
        } else {
            long delay = this.backoff.duration();
            logger.fine(String.format("will wait %dms before reconnect attempt", delay));
            this.reconnecting = true;
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EventThread.exec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (self.skipReconnect) {
                                return;
                            }
                            logger.fine("attempting reconnect");
                            int attempts = self.backoff.getAttempts();
                            self.emitAll(Manager.EVENT_RECONNECT_ATTEMPT, new Object[]{attempts});
                            self.emitAll(Manager.EVENT_RECONNECTING, new Object[]{attempts});
                            if (self.skipReconnect) {
                                return;
                            }
                            self.open(new OpenCallback(){

                                @Override
                                public void call(Exception err) {
                                    if (err != null) {
                                        logger.fine("reconnect attempt error");
                                        self.reconnecting = false;
                                        self.reconnect();
                                        self.emitAll(Manager.EVENT_RECONNECT_ERROR, new Object[]{err});
                                    } else {
                                        logger.fine("reconnect success");
                                        self.onreconnect();
                                    }
                                }
                            });
                        }
                    });
                }
            }, delay);
            this.subs.add(new On.Handle(){

                @Override
                public void destroy() {
                    timer.cancel();
                }
            });
        }
    }

    private void onreconnect() {
        int attempts = this.backoff.getAttempts();
        this.reconnecting = false;
        this.backoff.reset();
        this.updateSocketIds();
        this.emitAll(EVENT_RECONNECT, attempts);
    }

    public static class Options
    extends Socket.Options {
        public boolean reconnection = true;
        public int reconnectionAttempts;
        public long reconnectionDelay;
        public long reconnectionDelayMax;
        public double randomizationFactor;
        public long timeout = 20000L;
    }

    private static class Engine
    extends com.github.nkzawa.engineio.client.Socket {
        Engine(URI uri, Socket.Options opts) {
            super(uri, opts);
        }
    }

    public static interface OpenCallback {
        public void call(Exception var1);
    }

    static enum ReadyState {
        CLOSED,
        OPENING,
        OPEN;

    }
}

