/*
 * Decompiled with CFR 0.152.
 */
package com.github.nkzawa.backo;

public class Backoff {
    private long ms = 100L;
    private long max = 10000L;
    private int factor = 2;
    private double jitter = 0.0;
    private int attempts = 0;

    public long duration() {
        long ms = this.ms * (long)Math.pow(this.factor, this.attempts++);
        if (this.jitter != 0.0) {
            double rand = Math.random();
            int deviation = (int)Math.floor(rand * this.jitter * (double)ms);
            ms = ((int)Math.floor(rand * 10.0) & 1) == 0 ? ms - (long)deviation : ms + (long)deviation;
        }
        return Math.min(ms, this.max);
    }

    public void reset() {
        this.attempts = 0;
    }

    public Backoff setMin(long min) {
        this.ms = min;
        return this;
    }

    public Backoff setMax(long max) {
        this.max = max;
        return this;
    }

    public Backoff setFactor(int factor) {
        this.factor = factor;
        return this;
    }

    public Backoff setJitter(double jitter) {
        this.jitter = jitter;
        return this;
    }

    public int getAttempts() {
        return this.attempts;
    }
}

