/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.google.android.material.imageview.ShapeableImageView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/GlideHelper;", "", "()V", "Companion", "imagepicker_release"})
public final class GlideHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean isTransitionEnabled = true;
    @NotNull
    private static RequestOptions options;

    static {
        BaseRequestOptions baseRequestOptions = ((RequestOptions)((RequestOptions)new RequestOptions().placeholder(R.drawable.imagepicker_img_placeholder)).error(R.drawable.imagepicker_img_placeholder)).centerCrop();
        Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"RequestOptions()\n       \u2026            .centerCrop()");
        options = (RequestOptions)baseRequestOptions;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/GlideHelper$Companion;", "", "()V", "isTransitionEnabled", "", "options", "Lcom/bumptech/glide/request/RequestOptions;", "loadImage", "", "imageView", "Landroid/widget/ImageView;", "uri", "Landroid/net/Uri;", "loadPreviewImage", "Lcom/google/android/material/imageview/ShapeableImageView;", "setConfig", "placeholderResId", "", "errorResId", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void setConfig(boolean isTransitionEnabled, int placeholderResId, int errorResId) {
            isTransitionEnabled = isTransitionEnabled;
            BaseRequestOptions baseRequestOptions = ((RequestOptions)options.placeholder(placeholderResId != 0 ? placeholderResId : R.drawable.imagepicker_img_placeholder)).error(errorResId != 0 ? errorResId : R.drawable.imagepicker_img_placeholder);
            Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"options\n                \u2026gepicker_img_placeholder)");
            options = (RequestOptions)baseRequestOptions;
        }

        public final void loadImage(@NotNull ImageView imageView, @NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            RequestBuilder requestBuilder = Glide.with((Context)imageView.getContext()).load(uri).apply((BaseRequestOptions)options);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"with(imageView.context)\n\u2026          .apply(options)");
            RequestBuilder builder = requestBuilder;
            if (isTransitionEnabled) {
                RequestBuilder requestBuilder2 = builder.transition((TransitionOptions)DrawableTransitionOptions.withCrossFade());
                Intrinsics.checkNotNullExpressionValue((Object)requestBuilder2, (String)"builder.transition(Drawa\u2026nOptions.withCrossFade())");
                builder = requestBuilder2;
            }
            builder.into(imageView);
        }

        public final void loadPreviewImage(@NotNull ShapeableImageView imageView, @NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            imageView.post(() -> Companion.loadPreviewImage$lambda$0(imageView, uri));
        }

        private static final void loadPreviewImage$lambda$0(ShapeableImageView $imageView, Uri $uri) {
            Intrinsics.checkNotNullParameter((Object)$imageView, (String)"$imageView");
            Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
            Glide.with((Context)$imageView.getContext()).load($uri).addListener((RequestListener)new RequestListener<Drawable>($imageView){
                final /* synthetic */ ShapeableImageView $imageView;
                {
                    this.$imageView = $imageView;
                }

                public boolean onLoadFailed(@Nullable GlideException e, @Nullable Object model, @NotNull Target<Drawable> target, boolean isFirstResource) {
                    Intrinsics.checkNotNullParameter(target, (String)"target");
                    return false;
                }

                public boolean onResourceReady(@NotNull Drawable resource, @NotNull Object model, @Nullable Target<Drawable> target, @NotNull DataSource dataSource, boolean isFirstResource) {
                    Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                    Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                    Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                    int height = resource.getIntrinsicHeight() * this.$imageView.getMeasuredWidth() / resource.getIntrinsicWidth();
                    if (height < this.$imageView.getMeasuredWidth()) {
                        height = this.$imageView.getMeasuredWidth();
                    }
                    Context context = this.$imageView.getContext();
                    Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Activity");
                    int maxHeight = (int)((double)DeviceHelper.INSTANCE.getScreenHeight((Activity)context) * 0.8);
                    if (height > maxHeight) {
                        height = maxHeight;
                    }
                    this.$imageView.getLayoutParams().height = height;
                    this.$imageView.setImageDrawable(resource);
                    return false;
                }
            }).preload();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

