/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.widget;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/nguyenhoanglam/imagepicker/widget/GridSpacingItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "spanCount", "", "spacing", "(II)V", "mNeedLeftSpacing", "", "getItemOffsets", "", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "imagepicker_release"})
public final class GridSpacingItemDecoration
extends RecyclerView.ItemDecoration {
    private final int spanCount;
    private final int spacing;
    private boolean mNeedLeftSpacing;

    public GridSpacingItemDecoration(int spanCount, int spacing) {
        this.spanCount = spanCount;
        this.spacing = spacing;
        this.mNeedLeftSpacing = true;
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int frameWidth = (parent.getWidth() - this.spacing * (this.spanCount - 1)) / this.spanCount;
        int padding = parent.getWidth() / this.spanCount - frameWidth;
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView.LayoutParams");
        int itemPosition = ((RecyclerView.LayoutParams)layoutParams).getBindingAdapterPosition();
        outRect.top = itemPosition < this.spanCount ? 0 : this.spacing;
        if (itemPosition % this.spanCount == 0) {
            outRect.left = 0;
            outRect.right = padding;
            this.mNeedLeftSpacing = true;
        } else if ((itemPosition + 1) % this.spanCount == 0) {
            this.mNeedLeftSpacing = false;
            outRect.right = 0;
            outRect.left = padding;
        } else if (this.mNeedLeftSpacing) {
            this.mNeedLeftSpacing = false;
            outRect.left = this.spacing - padding;
            outRect.right = (itemPosition + 2) % this.spanCount == 0 ? this.spacing - padding : this.spacing / 2;
        } else if ((itemPosition + 2) % this.spanCount == 0) {
            this.mNeedLeftSpacing = false;
            outRect.left = this.spacing / 2;
            outRect.right = this.spacing - padding;
        } else {
            this.mNeedLeftSpacing = false;
            outRect.left = this.spacing / 2;
            outRect.right = this.spacing / 2;
        }
        outRect.bottom = 0;
    }
}

