/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.net.Uri;
import android.provider.MediaStore;
import com.nguyenhoanglam.imagepicker.helper.DeviceHelper;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006JF\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0004j\b\u0012\u0004\u0012\u00020\f`\u00062\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u0018"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/ImageHelper;", "", "()V", "filterImages", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "images", "bucketId", "", "(Ljava/util/ArrayList;Ljava/lang/Long;)Ljava/util/ArrayList;", "findImageIndex", "", "image", "findImageIndexes", "subImages", "folderListFromImages", "", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "getImageCollectionUri", "Landroid/net/Uri;", "isGifFormat", "", "singleListFromImage", "imagepicker_release"})
public final class ImageHelper {
    @NotNull
    public static final ImageHelper INSTANCE = new ImageHelper();

    private ImageHelper() {
    }

    @NotNull
    public final ArrayList<Image> singleListFromImage(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(image);
        return images;
    }

    @NotNull
    public final List<Folder> folderListFromImages(@NotNull List<Image> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        Map folderMap = new LinkedHashMap();
        for (Image image : images) {
            long bucketId = image.getBucketId();
            String bucketName = image.getBucketName();
            Folder folder = (Folder)folderMap.get(bucketId);
            if (folder == null) {
                folder = new Folder(bucketId, bucketName, null, 4, null);
                Long l = bucketId;
                folderMap.put(l, folder);
            }
            folder.getImages().add(image);
        }
        return new ArrayList(folderMap.values());
    }

    @NotNull
    public final ArrayList<Image> filterImages(@NotNull ArrayList<Image> images, @Nullable Long bucketId) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter(images, (String)"images");
                if (bucketId == null) break block3;
                long l = 0L;
                if (bucketId != l) break block4;
            }
            return images;
        }
        ArrayList<Image> filteredImages = new ArrayList<Image>();
        for (Image image : images) {
            Long l = bucketId;
            if (l == null || image.getBucketId() != l.longValue()) continue;
            filteredImages.add(image);
        }
        return filteredImages;
    }

    public final int findImageIndex(@NotNull Image image, @NotNull ArrayList<Image> images) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        int n = images.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)images.get(i).getUri(), (Object)image.getUri())) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public final ArrayList<Integer> findImageIndexes(@NotNull ArrayList<Image> subImages, @NotNull ArrayList<Image> images) {
        Intrinsics.checkNotNullParameter(subImages, (String)"subImages");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        block0: for (Image image : subImages) {
            int n = images.size();
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)images.get(i).getUri(), (Object)image.getUri())) continue;
                indexes.add(i);
                continue block0;
            }
        }
        return indexes;
    }

    public final boolean isGifFormat(@NotNull Image image) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        String fileName = image.getName();
        if (StringsKt.contains$default((CharSequence)fileName, (CharSequence)".", (boolean)false, (int)2, null)) {
            String string3 = fileName.substring(StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null) + 1, fileName.length());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string2 = "";
        }
        String extension = string2;
        return StringsKt.equals((String)extension, (String)"gif", (boolean)true);
    }

    @NotNull
    public final Uri getImageCollectionUri() {
        Uri uri;
        if (DeviceHelper.INSTANCE.isMinSdk29()) {
            Uri uri2 = MediaStore.Images.Media.getContentUri((String)"external_primary");
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"getContentUri(MediaStore.VOLUME_EXTERNAL_PRIMARY)");
        } else {
            Uri uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"EXTERNAL_CONTENT_URI");
        }
        return uri;
    }
}

