/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.GlideHelper;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.ToastHelper;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.ui.adapter.BaseRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0003&'(B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0014\u0010\u001e\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u001fJ\u001e\u0010 \u001a\u00020\u00122\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rJ\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter;", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/BaseRecyclerViewAdapter;", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter$ImageViewHolder;", "context", "Landroid/content/Context;", "config", "Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;", "imageSelectListener", "Lcom/nguyenhoanglam/imagepicker/listener/OnImageSelectListener;", "(Landroid/content/Context;Lcom/nguyenhoanglam/imagepicker/model/ImagePickerConfig;Lcom/nguyenhoanglam/imagepicker/listener/OnImageSelectListener;)V", "images", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "selectedImages", "getItemCount", "", "onBindViewHolder", "", "viewHolder", "position", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "selectOrRemoveImage", "image", "setData", "", "setSelectedImages", "setupItemForeground", "view", "Landroid/view/View;", "isSelected", "", "ImageSelectedOrUpdated", "ImageUnselected", "ImageViewHolder", "imagepicker_release"})
public final class ImagePickerAdapter
extends BaseRecyclerViewAdapter<ImageViewHolder> {
    @NotNull
    private final ImagePickerConfig config;
    @NotNull
    private final OnImageSelectListener imageSelectListener;
    @NotNull
    private final ArrayList<Image> selectedImages;
    @NotNull
    private final ArrayList<Image> images;

    public ImagePickerAdapter(@NotNull Context context, @NotNull ImagePickerConfig config, @NotNull OnImageSelectListener imageSelectListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)imageSelectListener, (String)"imageSelectListener");
        super(context);
        this.config = config;
        this.imageSelectListener = imageSelectListener;
        this.selectedImages = new ArrayList();
        this.images = new ArrayList();
    }

    @NotNull
    public ImageViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View itemView = this.getInflater().inflate(R.layout.imagepicker_item_image, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return new ImageViewHolder(itemView, this.config.isShowNumberIndicator(), this.config.getSelectedIndicatorColor());
    }

    public void onBindViewHolder(@NotNull ImageViewHolder viewHolder, int position, @NotNull List<Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            this.onBindViewHolder(viewHolder, position);
        } else {
            Object it;
            Object element$iv;
            Iterator iterator;
            boolean bl;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block16: {
                $this$any$iv = payloads;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(it instanceof ImageSelectedOrUpdated)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                if (this.config.isShowNumberIndicator()) {
                    Image image = this.images.get(position);
                    Intrinsics.checkNotNullExpressionValue((Object)image, (String)"images[position]");
                    Image image2 = image;
                    int selectedIndex = ImageHelper.INSTANCE.findImageIndex(image2, this.selectedImages);
                    viewHolder.getSelectedNumber().setText((CharSequence)String.valueOf(selectedIndex + 1));
                    viewHolder.getSelectedNumber().setVisibility(0);
                    viewHolder.getSelectedIcon().setVisibility(8);
                } else {
                    viewHolder.getSelectedIcon().setVisibility(0);
                    viewHolder.getSelectedNumber().setVisibility(8);
                }
                this.setupItemForeground((View)viewHolder.getImage(), true);
            } else {
                boolean bl3;
                block17: {
                    $this$any$iv = payloads;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            it = element$iv = iterator.next();
                            boolean bl4 = false;
                            if (!(it instanceof ImageUnselected)) continue;
                            bl3 = true;
                            break block17;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    if (this.config.isShowNumberIndicator()) {
                        viewHolder.getSelectedNumber().setVisibility(8);
                    } else {
                        viewHolder.getSelectedIcon().setVisibility(8);
                    }
                    this.setupItemForeground((View)viewHolder.getImage(), false);
                } else {
                    this.onBindViewHolder(viewHolder, position);
                }
            }
        }
    }

    public void onBindViewHolder(@NotNull ImageViewHolder viewHolder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        Image image = this.images.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"images[position]");
        Image image2 = image;
        int selectedIndex = ImageHelper.INSTANCE.findImageIndex(image2, this.selectedImages);
        boolean isSelected = this.config.isMultipleMode() && selectedIndex != -1;
        GlideHelper.Companion.loadImage(viewHolder.getImage(), image2.getUri());
        this.setupItemForeground((View)viewHolder.getImage(), isSelected);
        viewHolder.getGifIndicator().setVisibility(ImageHelper.INSTANCE.isGifFormat(image2) ? 0 : 8);
        viewHolder.getSelectedIcon().setVisibility(isSelected && !this.config.isShowNumberIndicator() ? 0 : 8);
        viewHolder.getSelectedNumber().setVisibility(isSelected && this.config.isShowNumberIndicator() ? 0 : 8);
        if (viewHolder.getSelectedNumber().getVisibility() == 0) {
            viewHolder.getSelectedNumber().setText((CharSequence)String.valueOf(selectedIndex + 1));
        }
        viewHolder.itemView.setOnClickListener(arg_0 -> ImagePickerAdapter.onBindViewHolder$lambda$2(this, image2, position, arg_0));
    }

    public int getItemCount() {
        return this.images.size();
    }

    private final void setupItemForeground(View view, boolean isSelected) {
        if (Build.VERSION.SDK_INT >= 23) {
            view.setForeground(isSelected ? (Drawable)new ColorDrawable(ContextCompat.getColor((Context)this.getContext(), (int)R.color.imagepicker_black_alpha_30)) : null);
        }
    }

    private final void selectOrRemoveImage(Image image, int position) {
        if (this.config.isMultipleMode()) {
            int selectedIndex = ImageHelper.INSTANCE.findImageIndex(image, this.selectedImages);
            if (selectedIndex != -1) {
                this.selectedImages.remove(selectedIndex);
                this.notifyItemChanged(position, new ImageUnselected());
                ArrayList<Integer> indexes = ImageHelper.INSTANCE.findImageIndexes(this.selectedImages, this.images);
                for (Integer index : indexes) {
                    Intrinsics.checkNotNullExpressionValue((Object)index, (String)"index");
                    this.notifyItemChanged(index, new ImageSelectedOrUpdated());
                }
            } else {
                if (this.selectedImages.size() >= this.config.getMaxSize()) {
                    String string2;
                    if (this.config.getLimitMessage() != null) {
                        String string3 = this.config.getLimitMessage();
                        string2 = string3;
                        Intrinsics.checkNotNull((Object)string3);
                    } else {
                        String string4 = this.getContext().getResources().getString(R.string.imagepicker_msg_limit_images);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.resources.getStr\u2026epicker_msg_limit_images)");
                        String string5 = string4;
                        Object[] objectArray = new Object[]{this.config.getMaxSize()};
                        String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                        string2 = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
                    }
                    String message = string2;
                    ToastHelper.Companion.show$default(ToastHelper.Companion, this.getContext(), message, 0, 4, null);
                    return;
                }
                this.selectedImages.add(image);
                this.notifyItemChanged(position, new ImageSelectedOrUpdated());
            }
            this.imageSelectListener.onSelectedImagesChanged(this.selectedImages);
        } else {
            this.imageSelectListener.onSingleModeImageSelected(image);
        }
    }

    public final void setData(@NotNull List<Image> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        this.images.clear();
        this.images.addAll((Collection<Image>)images);
        this.notifyDataSetChanged();
    }

    public final void setSelectedImages(@NotNull ArrayList<Image> selectedImages) {
        Intrinsics.checkNotNullParameter(selectedImages, (String)"selectedImages");
        this.selectedImages.clear();
        this.selectedImages.addAll((Collection<Image>)selectedImages);
        this.notifyDataSetChanged();
    }

    private static final void onBindViewHolder$lambda$2(ImagePickerAdapter this$0, Image $image, int $position, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$image, (String)"$image");
        this$0.selectOrRemoveImage($image, $position);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter$ImageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "isShowNumberIndicator", "", "indicatorColor", "", "(Landroid/view/View;ZLjava/lang/String;)V", "gifIndicator", "getGifIndicator", "()Landroid/view/View;", "image", "Landroid/widget/ImageView;", "getImage", "()Landroid/widget/ImageView;", "selectedIcon", "getSelectedIcon", "selectedNumber", "Landroid/widget/TextView;", "getSelectedNumber", "()Landroid/widget/TextView;", "imagepicker_release"})
    public static final class ImageViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView image;
        @NotNull
        private final ImageView selectedIcon;
        @NotNull
        private final TextView selectedNumber;
        @NotNull
        private final View gifIndicator;

        public ImageViewHolder(@NotNull View itemView, boolean isShowNumberIndicator, @NotNull String indicatorColor) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            Intrinsics.checkNotNullParameter((Object)indicatorColor, (String)"indicatorColor");
            super(itemView);
            View view = itemView.findViewById(R.id.image_thumbnail);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.image_thumbnail)");
            this.image = (ImageView)view;
            View view2 = itemView.findViewById(R.id.image_selected_icon);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.id.image_selected_icon)");
            this.selectedIcon = (ImageView)view2;
            View view3 = itemView.findViewById(R.id.text_selected_number);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView.findViewById(R.id.text_selected_number)");
            this.selectedNumber = (TextView)view3;
            View view4 = itemView.findViewById(R.id.gif_indicator);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"itemView.findViewById(R.id.gif_indicator)");
            this.gifIndicator = view4;
            Drawable drawable2 = isShowNumberIndicator ? this.selectedNumber.getBackground().mutate() : this.selectedIcon.getBackground().mutate();
            Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
            GradientDrawable drawable3 = (GradientDrawable)drawable2;
            drawable3.setColor(Color.parseColor((String)indicatorColor));
        }

        @NotNull
        public final ImageView getImage() {
            return this.image;
        }

        @NotNull
        public final ImageView getSelectedIcon() {
            return this.selectedIcon;
        }

        @NotNull
        public final TextView getSelectedNumber() {
            return this.selectedNumber;
        }

        @NotNull
        public final View getGifIndicator() {
            return this.gifIndicator;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter$ImageSelectedOrUpdated;", "", "()V", "imagepicker_release"})
    public static final class ImageSelectedOrUpdated {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter$ImageUnselected;", "", "()V", "imagepicker_release"})
    public static final class ImageUnselected {
    }
}

