/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Application;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.databinding.ImagepickerFragmentBinding;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.helper.LayoutManagerHelper;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener;
import com.nguyenhoanglam.imagepicker.model.CallbackStatus;
import com.nguyenhoanglam.imagepicker.model.GridCount;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.ImagePickerConfig;
import com.nguyenhoanglam.imagepicker.model.Result;
import com.nguyenhoanglam.imagepicker.ui.adapter.ImagePickerAdapter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.BaseFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFragment;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModel;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImagePickerViewModelFactory;
import com.nguyenhoanglam.imagepicker.widget.GridSpacingItemDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0014\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010&\u001a\u00020\u0019H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment;", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/BaseFragment;", "()V", "_binding", "Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerFragmentBinding;", "binding", "getBinding", "()Lcom/nguyenhoanglam/imagepicker/databinding/ImagepickerFragmentBinding;", "bucketId", "", "Ljava/lang/Long;", "gridCount", "Lcom/nguyenhoanglam/imagepicker/model/GridCount;", "gridLayoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "imageAdapter", "Lcom/nguyenhoanglam/imagepicker/ui/adapter/ImagePickerAdapter;", "itemDecoration", "Lcom/nguyenhoanglam/imagepicker/widget/GridSpacingItemDecoration;", "selectedImageObserver", "com/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$selectedImageObserver$1", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$selectedImageObserver$1;", "viewModel", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "handleOnConfigurationChanged", "", "handleResult", "result", "Lcom/nguyenhoanglam/imagepicker/model/Result;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDestroyView", "Companion", "imagepicker_release"})
public final class ImageFragment
extends BaseFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ImagepickerFragmentBinding _binding;
    @Nullable
    private Long bucketId;
    private GridCount gridCount;
    private ImagePickerViewModel viewModel;
    private ImagePickerAdapter imageAdapter;
    private GridLayoutManager gridLayoutManager;
    private GridSpacingItemDecoration itemDecoration;
    @NotNull
    private final selectedImageObserver.1 selectedImageObserver = new Observer<ArrayList<Image>>(this){
        final /* synthetic */ ImageFragment this$0;
        {
            this.this$0 = $receiver;
        }

        public void onChanged(@NotNull ArrayList<Image> it) {
            Intrinsics.checkNotNullParameter(it, (String)"it");
            ImagePickerAdapter imagePickerAdapter = ImageFragment.access$getImageAdapter$p(this.this$0);
            if (imagePickerAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                imagePickerAdapter = null;
            }
            imagePickerAdapter.setSelectedImages(it);
            ImagePickerViewModel imagePickerViewModel = ImageFragment.access$getViewModel$p(this.this$0);
            if (imagePickerViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                imagePickerViewModel = null;
            }
            imagePickerViewModel.getSelectedImages().removeObserver((Observer)this);
        }
    };
    @NotNull
    public static final String BUCKET_ID = "BucketId";
    @NotNull
    public static final String GRID_COUNT = "GridCount";

    private final ImagepickerFragmentBinding getBinding() {
        ImagepickerFragmentBinding imagepickerFragmentBinding = this._binding;
        Intrinsics.checkNotNull((Object)imagepickerFragmentBinding);
        return imagepickerFragmentBinding;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void $this$onCreate_u24lambda_u2d0;
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        this.bucketId = bundle != null ? Long.valueOf(bundle.getLong(BUCKET_ID)) : null;
        Bundle bundle2 = this.getArguments();
        GridCount gridCount = bundle2 != null ? (GridCount)bundle2.getParcelable(GRID_COUNT) : null;
        Intrinsics.checkNotNull((Object)gridCount);
        this.gridCount = gridCount;
        FragmentActivity fragmentActivity = this.requireActivity();
        ImageFragment imageFragment = this;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$onCreate_u24lambda_u2d0, (String)"this");
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)$this$onCreate_u24lambda_u2d0;
        Application application = this.requireActivity().getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"requireActivity().application");
        imageFragment.viewModel = (ImagePickerViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new ImagePickerViewModelFactory(application)).get(ImagePickerViewModel.class);
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        GridLayoutManager gridLayoutManager;
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        ImagePickerViewModel imagePickerViewModel = this.viewModel;
        if (imagePickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel = null;
        }
        ImagePickerConfig config = imagePickerViewModel.getConfig();
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        FragmentActivity fragmentActivity2 = this.getActivity();
        if (fragmentActivity2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.nguyenhoanglam.imagepicker.listener.OnImageSelectListener");
        }
        this.imageAdapter = new ImagePickerAdapter((Context)fragmentActivity, config, (OnImageSelectListener)fragmentActivity2);
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        GridCount gridCount = this.gridCount;
        if (gridCount == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridCount");
            gridCount = null;
        }
        if ((gridLayoutManager = (this.gridLayoutManager = LayoutManagerHelper.INSTANCE.newInstance(context, gridCount))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager = null;
        }
        this.itemDecoration = new GridSpacingItemDecoration(gridLayoutManager.getSpanCount(), (int)this.getResources().getDimension(R.dimen.imagepicker_grid_spacing));
        this._binding = ImagepickerFragmentBinding.inflate(inflater, container, false);
        Object object = this.getBinding();
        ImagepickerFragmentBinding $this$onCreateView_u24lambda_u2d2 = object;
        boolean bl = false;
        $this$onCreateView_u24lambda_u2d2.getRoot().setBackgroundColor(Color.parseColor((String)config.getBackgroundColor()));
        Object object2 = new int[]{Color.parseColor((String)config.getProgressIndicatorColor())};
        $this$onCreateView_u24lambda_u2d2.progressIndicator.setIndicatorColor(object2);
        Object $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1 = object2 = (Object)$this$onCreateView_u24lambda_u2d2.recyclerView;
        boolean bl2 = false;
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.setHasFixedSize(true);
        GridLayoutManager gridLayoutManager2 = this.gridLayoutManager;
        if (gridLayoutManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager2 = null;
        }
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager2);
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
            gridSpacingItemDecoration = null;
        }
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
        ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
        if (imagePickerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
            imagePickerAdapter = null;
        }
        $this$onCreateView_u24lambda_u2d2_u24lambda_u2d1.setAdapter((RecyclerView.Adapter)imagePickerAdapter);
        ImagePickerViewModel imagePickerViewModel2 = this.viewModel;
        if (imagePickerViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            imagePickerViewModel2 = null;
        }
        Object $this$onCreateView_u24lambda_u2d4 = object = imagePickerViewModel2;
        boolean bl3 = false;
        ((ImagePickerViewModel)((Object)$this$onCreateView_u24lambda_u2d4)).getResult().observe(this.getViewLifecycleOwner(), arg_0 -> ImageFragment.onCreateView$lambda-4$lambda-3(this, arg_0));
        ((ImagePickerViewModel)((Object)$this$onCreateView_u24lambda_u2d4)).getSelectedImages().observe(this.getViewLifecycleOwner(), (Observer)this.selectedImageObserver);
        FrameLayout frameLayout = this.getBinding().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
        return (View)frameLayout;
    }

    private final void handleResult(Result result) {
        ImagepickerFragmentBinding imagepickerFragmentBinding;
        if (result.getStatus() instanceof CallbackStatus.SUCCESS) {
            ArrayList<Image> images = ImageHelper.INSTANCE.filterImages(result.getImages(), this.bucketId);
            if (!((Collection)images).isEmpty()) {
                ImagePickerAdapter imagePickerAdapter = this.imageAdapter;
                if (imagePickerAdapter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"imageAdapter");
                    imagePickerAdapter = null;
                }
                imagePickerAdapter.setData((List<Image>)images);
                this.getBinding().recyclerView.setVisibility(0);
            } else {
                this.getBinding().recyclerView.setVisibility(8);
            }
        } else {
            this.getBinding().recyclerView.setVisibility(8);
        }
        ImagepickerFragmentBinding $this$handleResult_u24lambda_u2d5 = imagepickerFragmentBinding = this.getBinding();
        boolean bl = false;
        $this$handleResult_u24lambda_u2d5.emptyText.setVisibility(result.getStatus() instanceof CallbackStatus.SUCCESS && result.getImages().isEmpty() ? 0 : 8);
        $this$handleResult_u24lambda_u2d5.progressIndicator.setVisibility(result.getStatus() instanceof CallbackStatus.FETCHING ? 0 : 8);
    }

    @Override
    public void handleOnConfigurationChanged() {
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        GridCount gridCount = this.gridCount;
        if (gridCount == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridCount");
            gridCount = null;
        }
        int newSpanCount = LayoutManagerHelper.INSTANCE.getSpanCountForCurrentConfiguration(context, gridCount);
        GridLayoutManager gridLayoutManager = this.gridLayoutManager;
        if (gridLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager = null;
        }
        this.itemDecoration = new GridSpacingItemDecoration(gridLayoutManager.getSpanCount(), (int)this.getResources().getDimension(R.dimen.imagepicker_grid_spacing));
        GridLayoutManager gridLayoutManager2 = this.gridLayoutManager;
        if (gridLayoutManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gridLayoutManager");
            gridLayoutManager2 = null;
        }
        gridLayoutManager2.setSpanCount(newSpanCount);
        RecyclerView recyclerView = this.getBinding().recyclerView;
        GridSpacingItemDecoration gridSpacingItemDecoration = this.itemDecoration;
        if (gridSpacingItemDecoration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"itemDecoration");
            gridSpacingItemDecoration = null;
        }
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)gridSpacingItemDecoration);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this._binding = null;
    }

    private static final void onCreateView$lambda-4$lambda-3(ImageFragment this$0, Result it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.handleResult(it);
    }

    public static final /* synthetic */ ImagePickerAdapter access$getImageAdapter$p(ImageFragment $this) {
        return $this.imageAdapter;
    }

    public static final /* synthetic */ ImagePickerViewModel access$getViewModel$p(ImageFragment $this) {
        return $this.viewModel;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment$Companion;", "", "()V", "BUCKET_ID", "", "GRID_COUNT", "newInstance", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFragment;", "gridCount", "Lcom/nguyenhoanglam/imagepicker/model/GridCount;", "bucketId", "", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImageFragment newInstance(long bucketId, @NotNull GridCount gridCount) {
            Intrinsics.checkNotNullParameter((Object)gridCount, (String)"gridCount");
            ImageFragment fragment = new ImageFragment();
            Bundle args = new Bundle();
            args.putLong(ImageFragment.BUCKET_ID, bucketId);
            args.putParcelable(ImageFragment.GRID_COUNT, (Parcelable)gridCount);
            fragment.setArguments(args);
            return fragment;
        }

        @NotNull
        public final ImageFragment newInstance(@NotNull GridCount gridCount) {
            Intrinsics.checkNotNullParameter((Object)gridCount, (String)"gridCount");
            ImageFragment fragment = new ImageFragment();
            Bundle args = new Bundle();
            args.putParcelable(ImageFragment.GRID_COUNT, (Parcelable)gridCount);
            fragment.setArguments(args);
            return fragment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

