/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import com.nguyenhoanglam.imagepicker.listener.OnImageLoaderListener;
import com.nguyenhoanglam.imagepicker.model.CallbackStatus;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.Result;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageFileLoader;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R0\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u00140\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImagePickerViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "config", "Lcom/nguyenhoanglam/imagepicker/model/Config;", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "imageFileLoader", "Lcom/nguyenhoanglam/imagepicker/ui/imagepicker/ImageFileLoader;", "result", "Landroidx/lifecycle/MutableLiveData;", "Lcom/nguyenhoanglam/imagepicker/model/Result;", "getResult", "()Landroidx/lifecycle/MutableLiveData;", "selectedImages", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "getSelectedImages", "setSelectedImages", "(Landroidx/lifecycle/MutableLiveData;)V", "fetchImages", "", "getConfig", "setConfig", "imagepicker_release"})
public final class ImagePickerViewModel
extends AndroidViewModel {
    private final Context context;
    private final ImageFileLoader imageFileLoader;
    private Config config;
    @NotNull
    public MutableLiveData<ArrayList<Image>> selectedImages;
    @NotNull
    private final MutableLiveData<Result> result;

    @NotNull
    public final MutableLiveData<ArrayList<Image>> getSelectedImages() {
        MutableLiveData<ArrayList<Image>> mutableLiveData = this.selectedImages;
        if (mutableLiveData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedImages");
        }
        return mutableLiveData;
    }

    public final void setSelectedImages(@NotNull MutableLiveData<ArrayList<Image>> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.selectedImages = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<Result> getResult() {
        return this.result;
    }

    public final void setConfig(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.selectedImages = new MutableLiveData(config.getSelectedImages());
    }

    @NotNull
    public final Config getConfig() {
        Config config = this.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return config;
    }

    public final void fetchImages() {
        ArrayList<Image> arrayList;
        CallbackStatus callbackStatus = CallbackStatus.FETCHING.INSTANCE;
        MutableLiveData<Result> mutableLiveData = this.result;
        boolean bl = false;
        ArrayList<Image> arrayList2 = arrayList = new ArrayList<Image>();
        CallbackStatus callbackStatus2 = callbackStatus;
        mutableLiveData.postValue((Object)new Result(callbackStatus2, arrayList2));
        this.imageFileLoader.abortLoadImages();
        this.imageFileLoader.loadDeviceImages(new OnImageLoaderListener(this){
            final /* synthetic */ ImagePickerViewModel this$0;

            public void onImageLoaded(@NotNull ArrayList<Image> images) {
                Intrinsics.checkParameterIsNotNull(images, (String)"images");
                this.this$0.getResult().postValue((Object)new Result(CallbackStatus.SUCCESS.INSTANCE, images));
            }

            public void onFailed(@NotNull Throwable throwable) {
                ArrayList<Image> arrayList;
                Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                CallbackStatus callbackStatus = CallbackStatus.SUCCESS.INSTANCE;
                MutableLiveData<Result> mutableLiveData = this.this$0.getResult();
                boolean bl = false;
                ArrayList<Image> arrayList2 = arrayList = new ArrayList<Image>();
                CallbackStatus callbackStatus2 = callbackStatus;
                mutableLiveData.postValue((Object)new Result(callbackStatus2, arrayList2));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public ImagePickerViewModel(@NotNull Application application) {
        ArrayList<Image> arrayList;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        super(application);
        Context context = this.context = application.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.imageFileLoader = new ImageFileLoader(context);
        CallbackStatus callbackStatus = CallbackStatus.IDLE.INSTANCE;
        ImagePickerViewModel imagePickerViewModel = this;
        boolean bl = false;
        ArrayList<Image> arrayList2 = arrayList = new ArrayList<Image>();
        CallbackStatus callbackStatus2 = callbackStatus;
        Result result = new Result(callbackStatus2, arrayList2);
        imagePickerViewModel.result = new MutableLiveData((Object)result);
    }
}

