/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.provider.MediaStore;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006JF\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0004j\b\u0012\u0004\u0012\u00020\f`\u00062\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\r\u001a\u00020\u0005J&\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0014\u00a8\u0006$"}, d2={"Lcom/nguyenhoanglam/imagepicker/helper/ImageHelper;", "", "()V", "filterImages", "Ljava/util/ArrayList;", "Lcom/nguyenhoanglam/imagepicker/model/Image;", "Lkotlin/collections/ArrayList;", "images", "bukketId", "", "(Ljava/util/ArrayList;Ljava/lang/Long;)Ljava/util/ArrayList;", "findImageIndex", "", "image", "findImageIndexes", "subImages", "folderListFromImages", "", "Lcom/nguyenhoanglam/imagepicker/model/Folder;", "getNameFromFilePath", "", "path", "grantAppPermission", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "fileUri", "Landroid/net/Uri;", "isGifFormat", "", "revokeAppPermission", "singleListFromImage", "singleListFromPath", "id", "imagepicker_release"})
public final class ImageHelper {
    public static final ImageHelper INSTANCE;

    private final String getNameFromFilePath(String path) {
        String string2;
        CharSequence charSequence = path;
        String string3 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.separator");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) {
            String string4 = path;
            CharSequence charSequence2 = path;
            String string5 = File.separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"File.separator");
            int n = StringsKt.lastIndexOf$default((CharSequence)charSequence2, (String)string5, (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string6 = string4;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            string2 = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = path;
        }
        return string2;
    }

    public final void grantAppPermission(@NotNull Context context, @NotNull Intent intent, @NotNull Uri fileUri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)fileUri, (String)"fileUri");
        List resolvedIntentActivities = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
            String packageName = resolvedIntentInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, fileUri, 3);
        }
    }

    public final void revokeAppPermission(@NotNull Context context, @NotNull Uri fileUri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fileUri, (String)"fileUri");
        context.revokeUriPermission(fileUri, 3);
    }

    @NotNull
    public final ArrayList<Image> singleListFromPath(long id2, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        boolean bl = false;
        ArrayList<Image> images = new ArrayList<Image>();
        Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2);
        String string2 = this.getNameFromFilePath(path);
        Uri uri2 = uri;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
        images.add(new Image(id2, string2, uri2, path, 0L, null, 48, null));
        return images;
    }

    @NotNull
    public final ArrayList<Image> singleListFromImage(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        boolean bl = false;
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(image);
        return images;
    }

    @NotNull
    public final List<Folder> folderListFromImages(@NotNull List<Image> images) {
        Intrinsics.checkParameterIsNotNull(images, (String)"images");
        Map folderMap = new LinkedHashMap();
        for (Image image : images) {
            long bucketId = image.getBucketId();
            String bucketName = image.getBucketName();
            Folder folder = (Folder)folderMap.get(bucketId);
            if (folder == null) {
                folder = new Folder(bucketId, bucketName, null, 4, null);
                folderMap.put(bucketId, folder);
            }
            folder.getImages().add(image);
        }
        return new ArrayList(folderMap.values());
    }

    @NotNull
    public final ArrayList<Image> filterImages(@NotNull ArrayList<Image> images, @Nullable Long bukketId) {
        Intrinsics.checkParameterIsNotNull(images, (String)"images");
        if (bukketId == null) {
            return images;
        }
        boolean bl = false;
        ArrayList<Image> filteredImages = new ArrayList<Image>();
        for (Image image : images) {
            Long l = bukketId;
            if (l == null || image.getBucketId() != l.longValue()) continue;
            filteredImages.add(image);
        }
        return filteredImages;
    }

    /*
     * WARNING - void declaration
     */
    public final int findImageIndex(@NotNull Image image, @NotNull ArrayList<Image> images) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull(images, (String)"images");
        int n = 0;
        int n2 = ((Collection)images).size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)images.get((int)i).getPath(), (Object)image.getPath())) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<Integer> findImageIndexes(@NotNull ArrayList<Image> subImages, @NotNull ArrayList<Image> images) {
        Intrinsics.checkParameterIsNotNull(subImages, (String)"subImages");
        Intrinsics.checkParameterIsNotNull(images, (String)"images");
        boolean bl = false;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        block0: for (Image image : subImages) {
            int n = 0;
            int n2 = ((Collection)images).size();
            while (n < n2) {
                void i;
                if (Intrinsics.areEqual((Object)images.get((int)i).getPath(), (Object)image.getPath())) {
                    indexes.add((int)i);
                    continue block0;
                }
                ++i;
            }
        }
        return indexes;
    }

    public final boolean isGifFormat(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        String string2 = image.getPath();
        int n = StringsKt.lastIndexOf$default((CharSequence)image.getPath(), (String)".", (int)0, (boolean)false, (int)6, null) + 1;
        int n2 = image.getPath().length();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String extension = string4;
        return StringsKt.equals((String)extension, (String)"gif", (boolean)true);
    }

    private ImageHelper() {
    }

    static {
        ImageHelper imageHelper;
        INSTANCE = imageHelper = new ImageHelper();
    }
}

