/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.imagepicker;

import android.content.Context;
import android.os.Parcelable;
import android.widget.Toast;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.adapter.FolderPickerAdapter;
import com.nguyenhoanglam.imagepicker.adapter.ImagePickerAdapter;
import com.nguyenhoanglam.imagepicker.listener.OnBackAction;
import com.nguyenhoanglam.imagepicker.listener.OnFolderClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectionListener;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.model.Folder;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageLoader;
import com.nguyenhoanglam.imagepicker.widget.GridSpacingItemDecoration;
import java.util.ArrayList;
import java.util.List;

public class RecyclerViewManager {
    private Context context;
    private RecyclerView recyclerView;
    private Config config;
    private GridLayoutManager layoutManager;
    private GridSpacingItemDecoration itemOffsetDecoration;
    private ImagePickerAdapter imageAdapter;
    private FolderPickerAdapter folderAdapter;
    private int imageColumns;
    private int folderColumns;
    private ImageLoader imageLoader;
    private Parcelable foldersState;
    private String title;
    private boolean isShowingFolder;

    public RecyclerViewManager(RecyclerView recyclerView, Config config, int orientation) {
        this.recyclerView = recyclerView;
        this.config = config;
        this.context = recyclerView.getContext();
        this.changeOrientation(orientation);
        this.imageLoader = new ImageLoader();
        this.isShowingFolder = config.isFolderMode();
    }

    public void setupAdapters(OnImageClickListener imageClickListener, final OnFolderClickListener folderClickListener) {
        ArrayList<Image> selectedImages = null;
        if (this.config.isMultipleMode() && !this.config.getSelectedImages().isEmpty()) {
            selectedImages = this.config.getSelectedImages();
        }
        this.imageAdapter = new ImagePickerAdapter(this.context, this.imageLoader, selectedImages, imageClickListener);
        this.folderAdapter = new FolderPickerAdapter(this.context, this.imageLoader, new OnFolderClickListener(){

            @Override
            public void onFolderClick(Folder folder) {
                RecyclerViewManager.this.foldersState = RecyclerViewManager.this.recyclerView.getLayoutManager().onSaveInstanceState();
                folderClickListener.onFolderClick(folder);
            }
        });
    }

    public void changeOrientation(int orientation) {
        this.imageColumns = orientation == 1 ? 3 : 5;
        this.folderColumns = orientation == 1 ? 2 : 4;
        int columns = this.isShowingFolder ? this.folderColumns : this.imageColumns;
        this.layoutManager = new GridLayoutManager(this.context, columns);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setHasFixedSize(true);
        this.setItemDecoration(columns);
    }

    private void setItemDecoration(int columns) {
        if (this.itemOffsetDecoration != null) {
            this.recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.itemOffsetDecoration);
        }
        this.itemOffsetDecoration = new GridSpacingItemDecoration(columns, this.context.getResources().getDimensionPixelSize(R.dimen.imagepicker_item_padding), false);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.itemOffsetDecoration);
        this.layoutManager.setSpanCount(columns);
    }

    public void setOnImageSelectionListener(OnImageSelectionListener imageSelectionListener) {
        this.checkAdapterIsInitialized();
        this.imageAdapter.setOnImageSelectionListener(imageSelectionListener);
    }

    public List<Image> getSelectedImages() {
        this.checkAdapterIsInitialized();
        return this.imageAdapter.getSelectedImages();
    }

    public void addSelectedImages(List<Image> images) {
        this.imageAdapter.addSelected(images);
    }

    private void checkAdapterIsInitialized() {
        if (this.imageAdapter == null) {
            throw new IllegalStateException("Must call setupAdapters first!");
        }
    }

    public boolean selectImage() {
        if (this.config.isMultipleMode()) {
            if (this.imageAdapter.getSelectedImages().size() >= this.config.getMaxSize()) {
                String message = String.format(this.config.getLimitMessage(), this.config.getMaxSize());
                Toast.makeText((Context)this.context, (CharSequence)message, (int)0).show();
                return false;
            }
        } else if (this.imageAdapter.getItemCount() > 0) {
            this.imageAdapter.removeAllSelected();
        }
        return true;
    }

    public void handleBack(OnBackAction action) {
        if (this.config.isFolderMode() && !this.isShowingFolder) {
            this.setFolderAdapter(null);
            action.onBackToFolder();
            return;
        }
        action.onFinishImagePicker();
    }

    public void setImageAdapter(List<Image> images, String title) {
        this.imageAdapter.setData(images);
        this.setItemDecoration(this.imageColumns);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.imageAdapter);
        this.title = title;
        this.isShowingFolder = false;
    }

    public void setFolderAdapter(List<Folder> folders) {
        this.folderAdapter.setData(folders);
        this.setItemDecoration(this.folderColumns);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.folderAdapter);
        this.isShowingFolder = true;
        if (this.foldersState != null) {
            this.layoutManager.setSpanCount(this.folderColumns);
            this.recyclerView.getLayoutManager().onRestoreInstanceState(this.foldersState);
        }
    }

    public String getTitle() {
        if (this.isShowingFolder) {
            return this.config.getFolderTitle();
        }
        if (this.config.isFolderMode()) {
            return this.title;
        }
        return this.config.getImageTitle();
    }

    public boolean isShowDoneButton() {
        return this.config.isMultipleMode() && (this.config.isAlwaysShowDoneButton() || this.imageAdapter.getSelectedImages().size() > 0);
    }
}

