/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.ui.camera;

import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.model.Config;
import com.nguyenhoanglam.imagepicker.ui.camera.CameraModule;
import com.nguyenhoanglam.imagepicker.ui.camera.OnImageReadyListener;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;

public class DefaultCameraModule
implements CameraModule,
Serializable {
    protected String imagePath;

    @Override
    public Intent getCameraIntent(Context context, Config config) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        new ImageHelper();
        File imageFile = ImageHelper.createImageFile(config.getSavePath());
        if (imageFile != null) {
            Context appContext = context.getApplicationContext();
            String providerName = String.format(Locale.ENGLISH, "%s%s", appContext.getPackageName(), ".fileprovider");
            Uri uri = FileProvider.getUriForFile((Context)appContext, (String)providerName, (File)imageFile);
            this.imagePath = imageFile.getAbsolutePath();
            intent.putExtra("output", (Parcelable)uri);
            ImageHelper.grantAppPermission(context, intent, uri);
            return intent;
        }
        return null;
    }

    @Override
    public void getImage(final Context context, Intent intent, final OnImageReadyListener imageReadyListener) {
        if (imageReadyListener == null) {
            throw new IllegalStateException("OnImageReadyListener must not be null");
        }
        if (this.imagePath == null) {
            imageReadyListener.onImageReady(null);
            return;
        }
        final Uri imageUri = Uri.parse((String)new File(this.imagePath).toString());
        if (imageUri != null) {
            MediaScannerConnection.scanFile((Context)context.getApplicationContext(), (String[])new String[]{imageUri.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                public void onScanCompleted(String path, Uri uri) {
                    if (path != null) {
                        path = DefaultCameraModule.this.imagePath;
                    }
                    imageReadyListener.onImageReady(ImageHelper.singleListFromPath(path));
                    ImageHelper.revokeAppPermission(context, imageUri);
                }
            });
        }
    }
}

