/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.nguyenhoanglam.imagepicker.R;
import com.nguyenhoanglam.imagepicker.helper.ImageHelper;
import com.nguyenhoanglam.imagepicker.listener.OnImageClickListener;
import com.nguyenhoanglam.imagepicker.listener.OnImageSelectionListener;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.ui.common.BaseRecyclerViewAdapter;
import com.nguyenhoanglam.imagepicker.ui.imagepicker.ImageLoader;
import java.util.ArrayList;
import java.util.List;

public class ImagePickerAdapter
extends BaseRecyclerViewAdapter<ImageViewHolder> {
    private List<Image> images = new ArrayList<Image>();
    private List<Image> selectedImages = new ArrayList<Image>();
    private OnImageClickListener itemClickListener;
    private OnImageSelectionListener imageSelectionListener;

    public ImagePickerAdapter(Context context, ImageLoader imageLoader, List<Image> selectedImages, OnImageClickListener itemClickListener) {
        super(context, imageLoader);
        this.itemClickListener = itemClickListener;
        if (selectedImages != null && !selectedImages.isEmpty()) {
            this.selectedImages.addAll(selectedImages);
        }
    }

    public ImageViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.getInflater().inflate(R.layout.imagepicker_item_image, parent, false);
        return new ImageViewHolder(itemView);
    }

    public void onBindViewHolder(final ImageViewHolder viewHolder, final int position) {
        final Image image = this.images.get(position);
        final boolean isSelected = this.isSelected(image);
        this.getImageLoader().loadImage(image.getPath(), viewHolder.image);
        viewHolder.gifIndicator.setVisibility(ImageHelper.isGifFormat(image) ? 0 : 8);
        viewHolder.alphaView.setAlpha(isSelected ? 0.5f : 0.0f);
        viewHolder.container.setForeground(isSelected ? ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.imagepicker_ic_selected) : null);
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean shouldSelect = ImagePickerAdapter.this.itemClickListener.onImageClick(view, viewHolder.getAdapterPosition(), !isSelected);
                if (isSelected) {
                    ImagePickerAdapter.this.removeSelected(image, position);
                } else if (shouldSelect) {
                    ImagePickerAdapter.this.addSelected(image, position);
                }
            }
        });
    }

    private boolean isSelected(Image image) {
        for (Image selectedImage : this.selectedImages) {
            if (!selectedImage.getPath().equals(image.getPath())) continue;
            return true;
        }
        return false;
    }

    public void setOnImageSelectionListener(OnImageSelectionListener imageSelectedListener) {
        this.imageSelectionListener = imageSelectedListener;
    }

    public int getItemCount() {
        return this.images.size();
    }

    public void setData(List<Image> images) {
        if (images != null) {
            this.images.clear();
            this.images.addAll(images);
        }
        this.notifyDataSetChanged();
    }

    public void addSelected(List<Image> images) {
        this.selectedImages.addAll(images);
        this.notifySelectionChanged();
    }

    public void addSelected(Image image, int position) {
        this.selectedImages.add(image);
        this.notifyItemChanged(position);
        this.notifySelectionChanged();
    }

    public void removeSelected(Image image, int position) {
        this.selectedImages.remove(image);
        this.notifyItemChanged(position);
        this.notifySelectionChanged();
    }

    public void removeAllSelected() {
        this.selectedImages.clear();
        this.notifyDataSetChanged();
        this.notifySelectionChanged();
    }

    private void notifySelectionChanged() {
        if (this.imageSelectionListener != null) {
            this.imageSelectionListener.onSelectionUpdate(this.selectedImages);
        }
    }

    public List<Image> getSelectedImages() {
        return this.selectedImages;
    }

    static class ImageViewHolder
    extends RecyclerView.ViewHolder {
        private FrameLayout container;
        private ImageView image;
        private View alphaView;
        private View gifIndicator;

        public ImageViewHolder(View itemView) {
            super(itemView);
            this.container = (FrameLayout)itemView;
            this.image = (ImageView)itemView.findViewById(R.id.image_thumbnail);
            this.alphaView = itemView.findViewById(R.id.view_alpha);
            this.gifIndicator = itemView.findViewById(R.id.gif_indicator);
        }
    }
}

