/*
 * Decompiled with CFR 0.152.
 */
package com.nguyenhoanglam.imagepicker.helper;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.nguyenhoanglam.imagepicker.model.Image;
import com.nguyenhoanglam.imagepicker.model.SavePath;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ImageHelper {
    private static final String TAG = "ImageHelper";

    public static File createImageFile(SavePath savePath) {
        File mediaStorageDir;
        String path = savePath.getPath();
        File file = mediaStorageDir = savePath.isFullPath() ? new File(path) : new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), path);
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            Log.d((String)TAG, (String)("Oops! Failed create " + path));
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "IMG_" + timeStamp;
        File imageFile = null;
        try {
            imageFile = File.createTempFile(imageFileName, ".jpg", mediaStorageDir);
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("Oops! Failed create " + imageFileName + " file"));
        }
        return imageFile;
    }

    public static String getNameFromFilePath(String path) {
        if (path.contains(File.separator)) {
            return path.substring(path.lastIndexOf(File.separator) + 1);
        }
        return path;
    }

    public static void grantAppPermission(Context context, Intent intent, Uri fileUri) {
        List resolvedIntentActivities = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
            String packageName = resolvedIntentInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, fileUri, 3);
        }
    }

    public static void revokeAppPermission(Context context, Uri fileUri) {
        context.revokeUriPermission(fileUri, 3);
    }

    public static List<Image> singleListFromPath(String path) {
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(new Image(0L, ImageHelper.getNameFromFilePath(path), path));
        return images;
    }

    public static boolean isGifFormat(Image image) {
        String extension = image.getPath().substring(image.getPath().lastIndexOf(".") + 1, image.getPath().length());
        return extension.equalsIgnoreCase("gif");
    }
}

