/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebViewClient;
import androidx.webkit.WebViewAssetLoader;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.Utils;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.WhiteboardViewOptions;
import com.herewhite.sdk.domain.AssetsHttpsOptions;
import com.herewhite.sdk.internal.WhiteWebViewClient;
import wendu.dsbridge.special.DWebView;
import wendu.dsbridge.special.OnReturnValue;

public class WhiteboardView
extends DWebView
implements JsBridgeInterface {
    private static String sEntryUrl = "file:///android_asset/whiteboard/index.html";
    private boolean autoResize = true;
    private RefreshViewSizeStrategy delayStrategy;
    private WhiteSdk whiteSdk;
    private WhiteWebViewClient whiteWebViewClient;
    private String entryUrl = sEntryUrl;
    private WhiteboardViewOptions options = new WhiteboardViewOptions();

    public WhiteboardView(Context context) {
        this(context, (WhiteboardViewOptions)null);
    }

    public WhiteboardView(Context context, WhiteboardViewOptions options) {
        super(WhiteboardView.getFixedContext(context));
        if (options != null) {
            this.options = options;
        }
        this.init();
    }

    public WhiteboardView(Context context, AttributeSet attrs) {
        super(WhiteboardView.getFixedContext(context), attrs);
        this.init();
    }

    public static Context getFixedContext(Context context) {
        if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 23) {
            return context.createConfigurationContext(new Configuration());
        }
        return context;
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
        if (this.isInEditMode()) {
            return;
        }
        if (this.autoResize) {
            this.delayStrategy.refreshViewSize();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.delayStrategy.onDetachedFromWindow();
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public static void setEntryUrl(String entryUrl) {
        sEntryUrl = entryUrl;
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        this.getSettings().setTextZoom(100);
        this.setWebChromeClient(new FixWebChromeClient());
        this.initWebViewClients();
        this.resolveAssetsOptions();
        this.loadUrl(this.entryUrl);
        this.delayStrategy = new RefreshViewSizeStrategy(100);
    }

    private void resolveAssetsOptions() {
        if (!this.options.isEnableAssetsHttps()) {
            this.entryUrl = sEntryUrl;
            return;
        }
        AssetsHttpsOptions assetsHttpsOptions = this.options.getAssetsHttpsOptions();
        if (assetsHttpsOptions == null) {
            this.entryUrl = sEntryUrl;
            return;
        }
        this.entryUrl = assetsHttpsOptions.buildEntryUrl();
        WebViewAssetLoader assetLoader = new WebViewAssetLoader.Builder().setDomain(assetsHttpsOptions.getDomain()).addPathHandler(assetsHttpsOptions.getAssetsPath(), (WebViewAssetLoader.PathHandler)new WebViewAssetLoader.AssetsPathHandler(this.getContext().getApplicationContext())).build();
        this.whiteWebViewClient.setAssetLoader(assetLoader);
    }

    private void initWebViewClients() {
        this.whiteWebViewClient = new WhiteWebViewClient();
        super.setWebViewClient((WebViewClient)this.whiteWebViewClient);
    }

    public void setWebViewClient(WebViewClient client) {
        this.whiteWebViewClient.setDelegate(client);
    }

    @Override
    public <T> void callHandler(String method, Object[] args, OnReturnValue<T> handler) {
        super.callHandler(method, Utils.toBridgeMaps(args), handler);
    }

    @Override
    public void callHandler(String method, Object[] args) {
        this.callHandler(method, args, null);
    }

    @Override
    public <T> void callHandler(String method, OnReturnValue<T> handler) {
        this.callHandler(method, null, handler);
    }

    @Override
    public void callFocusView() {
        this.requestFocus();
    }

    void attachSdk(WhiteSdk whiteSdk) {
        this.whiteSdk = whiteSdk;
    }

    private class RefreshViewSizeStrategy {
        private final int delay;
        private Runnable refreshViewSize = () -> WhiteboardView.this.callHandler("displayer.refreshViewSize", new Object[0]);

        RefreshViewSizeStrategy(int delay) {
            this.delay = delay;
        }

        public void refreshViewSize() {
            WhiteboardView.this.removeCallbacks(this.refreshViewSize);
            WhiteboardView.this.postDelayed(this.refreshViewSize, this.delay);
        }

        public void onDetachedFromWindow() {
            WhiteboardView.this.removeCallbacks(this.refreshViewSize);
        }
    }

    class FixWebChromeClient
    extends WebChromeClient {
        FixWebChromeClient() {
        }

        public Bitmap getDefaultVideoPoster() {
            try {
                int width = 100;
                int height = 50;
                return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            catch (Exception e) {
                return super.getDefaultVideoPoster();
            }
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            if (WhiteboardView.this.whiteSdk != null) {
                WhiteboardView.this.whiteSdk.handleConsoleMessage(consoleMessage);
            }
            return super.onConsoleMessage(consoleMessage);
        }
    }
}

