/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.internal;

import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Message;
import android.view.KeyEvent;
import android.webkit.ClientCertRequest;
import android.webkit.HttpAuthHandler;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.RequiresApi;
import androidx.webkit.WebViewAssetLoader;

public final class WhiteWebViewClient
extends WebViewClient {
    private volatile WebViewClient delegate;
    private volatile WebViewAssetLoader assetLoader;

    public WhiteWebViewClient() {
    }

    public WhiteWebViewClient(WebViewAssetLoader assetLoader) {
        this.assetLoader = assetLoader;
    }

    public void setDelegate(WebViewClient delegate) {
        this.delegate = delegate;
    }

    public void setAssetLoader(WebViewAssetLoader assetLoader) {
        this.assetLoader = assetLoader;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        WebViewClient client = this.delegate;
        if (client != null) {
            return client.shouldOverrideUrlLoading(view, url);
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    @RequiresApi(api=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        WebViewClient client = this.delegate;
        if (client != null) {
            return client.shouldOverrideUrlLoading(view, request);
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        WebResourceResponse response;
        WebViewAssetLoader loader = this.assetLoader;
        if (loader != null && (response = loader.shouldInterceptRequest(request.getUrl())) != null) {
            return response;
        }
        WebViewClient client = this.delegate;
        if (client != null) {
            return client.shouldInterceptRequest(view, request);
        }
        return super.shouldInterceptRequest(view, request);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        WebResourceResponse response;
        WebViewAssetLoader loader = this.assetLoader;
        if (loader != null && (response = loader.shouldInterceptRequest(Uri.parse((String)url))) != null) {
            return response;
        }
        WebViewClient client = this.delegate;
        if (client != null) {
            return client.shouldInterceptRequest(view, url);
        }
        return super.shouldInterceptRequest(view, url);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onPageStarted(view, url, favicon);
            return;
        }
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onPageFinished(view, url);
            return;
        }
        super.onPageFinished(view, url);
    }

    public void onLoadResource(WebView view, String url) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onLoadResource(view, url);
            return;
        }
        super.onLoadResource(view, url);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onReceivedError(view, errorCode, description, failingUrl);
            return;
        }
        super.onReceivedError(view, errorCode, description, failingUrl);
    }

    @RequiresApi(api=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onReceivedError(view, request, error);
            return;
        }
        super.onReceivedError(view, request, error);
    }

    @RequiresApi(api=23)
    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onReceivedHttpError(view, request, errorResponse);
            return;
        }
        super.onReceivedHttpError(view, request, errorResponse);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onReceivedSslError(view, handler, error);
            return;
        }
        super.onReceivedSslError(view, handler, error);
    }

    public void onFormResubmission(WebView view, Message dontResend, Message resend) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onFormResubmission(view, dontResend, resend);
            return;
        }
        super.onFormResubmission(view, dontResend, resend);
    }

    public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.doUpdateVisitedHistory(view, url, isReload);
            return;
        }
        super.doUpdateVisitedHistory(view, url, isReload);
    }

    public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onReceivedClientCertRequest(view, request);
            return;
        }
        super.onReceivedClientCertRequest(view, request);
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onReceivedHttpAuthRequest(view, handler, host, realm);
            return;
        }
        super.onReceivedHttpAuthRequest(view, handler, host, realm);
    }

    public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onReceivedLoginRequest(view, realm, account, args);
            return;
        }
        super.onReceivedLoginRequest(view, realm, account, args);
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onScaleChanged(view, oldScale, newScale);
            return;
        }
        super.onScaleChanged(view, oldScale, newScale);
    }

    public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
        WebViewClient client = this.delegate;
        if (client != null) {
            client.onUnhandledKeyEvent(view, event);
            return;
        }
        super.onUnhandledKeyEvent(view, event);
    }

    @RequiresApi(api=26)
    public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
        WebViewClient client = this.delegate;
        if (client != null) {
            return client.onRenderProcessGone(view, detail);
        }
        return super.onRenderProcessGone(view, detail);
    }
}

