/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import androidx.annotation.NonNull;
import com.google.gson.JsonSyntaxException;
import com.herewhite.sdk.Displayer;
import com.herewhite.sdk.JsBridgeInterface;
import com.herewhite.sdk.PlayerListener;
import com.herewhite.sdk.SyncDisplayerState;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.EventListener;
import com.herewhite.sdk.domain.FrequencyEventListener;
import com.herewhite.sdk.domain.PlayerObserverMode;
import com.herewhite.sdk.domain.PlayerPhase;
import com.herewhite.sdk.domain.PlayerState;
import com.herewhite.sdk.domain.PlayerTimeInfo;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.internal.Logger;
import com.herewhite.sdk.internal.PlayerDelegate;
import java.util.concurrent.CopyOnWriteArrayList;
import wendu.dsbridge.special.OnReturnValue;

public class Player
extends Displayer {
    private final CopyOnWriteArrayList<PlayerListener> listeners = new CopyOnWriteArrayList();
    private SyncDisplayerState<PlayerState> syncPlayerState;
    private long scheduleTime = 0L;
    private long timeDuration;
    private long beginTimestamp;
    private int framesCount;
    private double playbackSpeed;
    private PlayerPhase playerPhase = PlayerPhase.waitingFirstFrame;
    private PlayerDelegate playerDelegate;
    private SyncDisplayerState.Listener<PlayerState> localPlayStateListener = modifyState -> this.post(() -> {
        for (PlayerListener listener : this.listeners) {
            listener.onPlayerStateChanged((PlayerState)modifyState);
        }
    });

    Player(String room, JsBridgeInterface bridge, int densityDpi) {
        super(room, bridge, densityDpi);
        this.syncPlayerState = new SyncDisplayerState<PlayerState>(PlayerState.class, true);
        this.syncPlayerState.setListener(this.localPlayStateListener);
    }

    public double getPlaybackSpeed() {
        return this.playbackSpeed;
    }

    public void setPlaybackSpeed(double playbackSpeed) {
        this.playbackSpeed = playbackSpeed;
        this.bridge.callHandler("player.setPlaybackSpeed", new Object[]{playbackSpeed});
    }

    public void getPlaybackSpeed(final Promise<Double> promise) {
        this.bridge.callHandler("player.state.playbackSpeed", new OnReturnValue<Number>(){

            public void onValue(Number value) {
                promise.then(value.doubleValue());
            }
        });
    }

    public void play() {
        this.bridge.callHandler("player.play", new Object[0]);
    }

    public void pause() {
        this.bridge.callHandler("player.pause", new Object[0]);
    }

    public void stop() {
        this.bridge.callHandler("player.stop", new Object[0]);
    }

    public void seekToScheduleTime(long seekTime) {
        this.bridge.callHandler("player.seekToScheduleTime", new Object[]{seekTime});
    }

    public void setObserverMode(PlayerObserverMode mode) {
        this.bridge.callHandler("player.setObserverMode", new Object[]{mode.name()});
    }

    public PlayerPhase getPlayerPhase() {
        return this.playerPhase;
    }

    public void getPhase(final Promise<PlayerPhase> promise) {
        this.bridge.callHandler("player.getBroadcastState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(PlayerPhase.valueOf(String.valueOf(o)));
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from getPhase", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in getPhase promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public PlayerState getPlayerState() {
        if (this.playerPhase == PlayerPhase.waitingFirstFrame) {
            return null;
        }
        return this.syncPlayerState.getDisplayerState();
    }

    public void getPlayerState(final Promise<PlayerState> promise) {
        this.bridge.callHandler("player.state.playerState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    PlayerState playerState = (PlayerState)Displayer.gson.fromJson(String.valueOf(o), PlayerState.class);
                    promise.then(playerState);
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from getPlayerState", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in getPlayerState promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public PlayerTimeInfo getPlayerTimeInfo() {
        return new PlayerTimeInfo(this.scheduleTime, this.timeDuration, this.framesCount, this.beginTimestamp);
    }

    void setPlayerTimeInfo(PlayerTimeInfo playerTimeInfo) {
        this.scheduleTime = playerTimeInfo.getScheduleTime();
        this.timeDuration = playerTimeInfo.getTimeDuration();
        this.framesCount = playerTimeInfo.getFramesCount();
        this.beginTimestamp = playerTimeInfo.getBeginTimestamp();
    }

    public void getPlayerTimeInfo(final Promise<PlayerTimeInfo> promise) {
        this.bridge.callHandler("player.state.timeInfo", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                promise.then(Player.this.getPlayerTimeInfo());
            }
        });
    }

    public void addPlayerListener(@NonNull PlayerListener playerListener) {
        this.listeners.addIfAbsent(playerListener);
    }

    public void removePlayerListener(@NonNull PlayerListener playerListener) {
        this.listeners.remove(playerListener);
    }

    PlayerDelegate getDelegate() {
        if (this.playerDelegate == null) {
            this.playerDelegate = new PlayerDelegateImpl();
        }
        return this.playerDelegate;
    }

    private class PlayerDelegateImpl
    implements PlayerDelegate {
        private PlayerDelegateImpl() {
        }

        @Override
        public void fireMagixEvent(EventEntry eventEntry) {
            Player.this.post(() -> {
                EventListener eventListener = (EventListener)Player.this.eventListenerMap.get(eventEntry.getEventName());
                if (eventListener != null) {
                    eventListener.onEvent(eventEntry);
                }
            });
        }

        @Override
        public void fireHighFrequencyEvent(EventEntry[] eventEntries) {
            Player.this.post(() -> {
                FrequencyEventListener eventListener = (FrequencyEventListener)Player.this.frequencyEventListenerMap.get(eventEntries[0].getEventName());
                if (eventListener != null) {
                    eventListener.onEvent(eventEntries);
                }
            });
        }

        @Override
        public void setPlayerPhase(PlayerPhase playerPhase) {
            Player.this.playerPhase = playerPhase;
            Player.this.post(() -> {
                for (PlayerListener listener : Player.this.listeners) {
                    listener.onPhaseChanged(playerPhase);
                }
            });
        }

        @Override
        public void onLoadFirstFrame() {
            Player.this.post(() -> {
                for (PlayerListener listener : Player.this.listeners) {
                    listener.onLoadFirstFrame();
                }
            });
        }

        @Override
        public void onSliceChanged(String slice) {
            Player.this.post(() -> {
                for (PlayerListener listener : Player.this.listeners) {
                    listener.onSliceChanged(slice);
                }
            });
        }

        @Override
        public void syncDisplayerState(String stateJSON) {
            if (Player.this.syncPlayerState != null) {
                Player.this.syncPlayerState.syncDisplayerState(stateJSON);
            }
        }

        @Override
        public void onStoppedWithError(SDKError error) {
            Player.this.post(() -> {
                for (PlayerListener listener : Player.this.listeners) {
                    listener.onStoppedWithError(error);
                }
            });
        }

        @Override
        public void setScheduleTime(long scheduleTime) {
            Player.this.scheduleTime = scheduleTime;
            Player.this.post(() -> {
                for (PlayerListener listener : Player.this.listeners) {
                    listener.onScheduleTimeChanged(scheduleTime);
                }
            });
        }

        @Override
        public void onCatchErrorWhenAppendFrame(SDKError error) {
            Player.this.post(() -> {
                for (PlayerListener listener : Player.this.listeners) {
                    listener.onCatchErrorWhenAppendFrame(error);
                }
            });
        }

        @Override
        public void onCatchErrorWhenRender(SDKError error) {
            Player.this.post(() -> {
                for (PlayerListener listener : Player.this.listeners) {
                    listener.onCatchErrorWhenRender(error);
                }
            });
        }
    }
}

