/*
 * Decompiled with CFR 0.152.
 */
package com.github.naoghuman.lib.fxml.core;

import com.github.naoghuman.lib.fxml.core.FXMLController;
import com.github.naoghuman.lib.fxml.core.FXMLModel;
import com.github.naoghuman.lib.fxml.internal.DefaultFXMLValidator;
import com.github.naoghuman.lib.logger.core.LoggerFacade;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;

public final class FXMLView {
    private static final String DEFAULT_SUFFIX_CSS = ".css";
    private static final String DEFAULT_SUFFIX_FXML = ".fxml";
    private static final String DEFAULT_SUFFIX_CONTROLLER = "Controller";
    private FXMLLoader fxmlLoader;
    private Object instance;
    private String baseBundleName;
    private String conventionalName;
    private URL urlForFXML;
    private Optional<ResourceBundle> resourceBundle = Optional.empty();
    private Optional<URL> urlForCSS = Optional.empty();

    public static FXMLView create(Class<? extends FXMLController> controller) {
        return FXMLView.create(controller, FXMLModel.EMPTY);
    }

    public static FXMLView create(Class<? extends FXMLController> controller, FXMLModel model) {
        return new FXMLView(controller, model);
    }

    private FXMLView(Class<? extends FXMLController> controller, FXMLModel model) {
        DefaultFXMLValidator.requireNonNull(controller);
        DefaultFXMLValidator.requireNonNull(model);
        this.initializeController(controller);
        this.initializeConventionalName();
        this.initializeURLforFXML();
        this.initializeResourceBundle(controller);
        this.initializeURLforCSS();
        this.initializeFXMLLoader(model);
    }

    private void initializeController(Class<? extends FXMLController> controller) {
        String controllerName = controller.getName();
        DefaultFXMLValidator.requireEndsWith(controllerName, DEFAULT_SUFFIX_CONTROLLER);
        try {
            this.instance = Class.forName(controllerName).newInstance();
            DefaultFXMLValidator.requireNonNull(this.instance);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LoggerFacade.getDefault().error(this.getClass(), String.format("Can't create a 'controller' instance from class: %s", controllerName), (Throwable)ex);
        }
    }

    private void initializeConventionalName() {
        String simpleName = this.getInstance().getClass().getSimpleName();
        DefaultFXMLValidator.requireEndsWith(simpleName, DEFAULT_SUFFIX_CONTROLLER);
        this.conventionalName = simpleName.substring(0, simpleName.lastIndexOf(DEFAULT_SUFFIX_CONTROLLER));
        this.conventionalName = this.conventionalName.toLowerCase();
        DefaultFXMLValidator.requireNonNullAndNotEmpty(this.conventionalName);
    }

    private void initializeURLforFXML() {
        this.urlForFXML = this.getInstance().getClass().getResource(this.getConventionalName() + DEFAULT_SUFFIX_FXML);
        if (this.urlForFXML == null) {
            throw new IllegalArgumentException(String.format("Can't find a '.fxml' resource with the name: %s%s", this.getConventionalName(), DEFAULT_SUFFIX_FXML));
        }
    }

    private void initializeResourceBundle(Class<? extends FXMLController> controller) {
        String controllerName = controller.getName();
        DefaultFXMLValidator.requireEndsWith(controllerName, DEFAULT_SUFFIX_CONTROLLER);
        this.baseBundleName = controllerName.substring(0, controllerName.lastIndexOf(DEFAULT_SUFFIX_CONTROLLER));
        this.baseBundleName = this.baseBundleName.toLowerCase();
        DefaultFXMLValidator.requireNonNullAndNotEmpty(this.baseBundleName);
        try {
            this.resourceBundle = Optional.ofNullable(ResourceBundle.getBundle(this.baseBundleName));
        }
        catch (MissingResourceException ex) {
            LoggerFacade.getDefault().debug(this.getClass(), String.format("Can't found a ResourceBundle with the specified 'base' name: %s", this.baseBundleName));
        }
    }

    private void initializeURLforCSS() {
        this.urlForCSS = Optional.ofNullable(this.getInstance().getClass().getResource(this.getConventionalName() + DEFAULT_SUFFIX_CSS));
    }

    private void initializeFXMLLoader(FXMLModel model) {
        try {
            this.fxmlLoader = new FXMLLoader();
            this.fxmlLoader.setController(this.getInstance());
            this.fxmlLoader.setLocation(this.getURLforFXML());
            this.getResourceBundle().ifPresent(bundle -> this.fxmlLoader.setResources(bundle));
            this.fxmlLoader.load();
            this.getRoot().ifPresent(root -> this.getURLforCSS().ifPresent(url -> root.getStylesheets().add((Object)url.toExternalForm())));
            this.getController().configure(model);
        }
        catch (IOException ex) {
            LoggerFacade.getDefault().error(this.getClass(), String.format("Can't load '.fxml' file with the path: %s", this.getURLforFXML().getPath()), (Throwable)ex);
        }
    }

    public String getBaseBundleName() {
        return this.baseBundleName;
    }

    public String getConventionalName() {
        return this.conventionalName;
    }

    private Object getInstance() {
        return this.instance;
    }

    public FXMLController getController() {
        return (FXMLController)this.fxmlLoader.getController();
    }

    public <T extends FXMLController> Optional<T> getController(Class<T> type) {
        DefaultFXMLValidator.requireNonNull(type);
        Optional value = Optional.empty();
        try {
            value = Optional.ofNullable(type.cast(this.getController()));
        }
        catch (Exception ex) {
            LoggerFacade.getDefault().warn(this.getClass(), String.format("Can't downcast FXMLController to type of '%s'. Return Optional.empty().", type.getName()), (Throwable)ex);
        }
        return value;
    }

    public Optional<ResourceBundle> getResourceBundle() {
        return this.resourceBundle;
    }

    public Optional<Parent> getRoot() {
        return Optional.ofNullable(this.fxmlLoader.getRoot());
    }

    public Optional<URL> getURLforCSS() {
        return this.urlForCSS;
    }

    public URL getURLforFXML() {
        return this.urlForFXML;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FXMLView [\n");
        sb.append("  controller       = ").append(this.getController().getClass().getName()).append(",\n");
        sb.append("  conventionalName = ").append(this.getConventionalName()).append(",\n");
        sb.append("  baseBundleName   = ").append(this.getBaseBundleName()).append(",\n");
        sb.append("  urlForFXML       = ").append(this.getURLforFXML() != null ? this.getURLforFXML().toString() : "<not-defined>").append(",\n");
        sb.append("  urlForCSS        = ").append(this.getURLforCSS().isPresent() ? this.getURLforCSS().get().toString() : "<not-defined>").append(",\n");
        sb.append("  root             = ").append(this.getRoot().isPresent() ? this.getRoot().get().toString() : "<not-defined>").append("\n");
        sb.append("]");
        return sb.toString();
    }
}

