/*
 * Decompiled with CFR 0.152.
 */
package com.github.naoghuman.lib.fxml.core;

import com.github.naoghuman.lib.fxml.internal.DefaultFXMLValidator;
import com.github.naoghuman.lib.logger.core.LoggerFacade;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class FXMLModel {
    public static final Long DEFAULT_ENTITY_ID = -1L;
    public static final FXMLModel EMPTY = new FXMLModel();
    private final HashMap<String, Object> data = new HashMap();
    private Optional<Class> entity = Optional.empty();
    private Optional<Long> entityId = Optional.empty();
    private Optional<String> modelType = Optional.empty();

    public void clearMetadata() {
        this.entity = Optional.empty();
        this.entityId = Optional.empty();
        this.modelType = Optional.empty();
    }

    public void clearData() {
        this.data.clear();
    }

    public boolean isSameEntity(Class entity, Long entityId) {
        DefaultFXMLValidator.requireNonNull(entity);
        DefaultFXMLValidator.requireNonNull(entityId);
        if (this.entity.isPresent() && this.entityId.isPresent()) {
            return this.entity.get().getName().equals(entity.getName()) && Objects.equals(this.getMetadataEntityId().get(), entityId);
        }
        return Boolean.FALSE;
    }

    public boolean isSameEntity(Class entity, Long entityId, String modelType) {
        DefaultFXMLValidator.requireNonNull(entity);
        DefaultFXMLValidator.requireNonNull(entityId);
        DefaultFXMLValidator.requireNonNullAndNotEmpty(modelType);
        if (this.entity.isPresent() && this.entityId.isPresent() && this.modelType.isPresent()) {
            return this.entity.get().getName().equals(entity.getName()) && Objects.equals(this.getMetadataEntityId().get(), entityId) && this.modelType.get().equals(modelType);
        }
        return Boolean.FALSE;
    }

    public <T> Optional<T> getData(Class<T> type, String key) {
        DefaultFXMLValidator.requireNonNullAndNotEmpty(key);
        DefaultFXMLValidator.requireNonNull(type);
        Optional value = Optional.empty();
        try {
            value = Optional.ofNullable(type.cast(this.data.get(key)));
        }
        catch (Exception ex) {
            LoggerFacade.getDefault().warn(this.getClass(), String.format("Can't cast the 'value' from 'key=%s' to 'Optional<T>=%s'. Return Optional.empty().", key, type.getName()), (Throwable)ex);
        }
        return value;
    }

    public HashMap<String, Object> getData() {
        return this.data;
    }

    public Optional<Class> getMetadataEntity() {
        return this.entity;
    }

    public Optional<Long> getMetadataEntityId() {
        return this.entityId;
    }

    public Optional<String> getMetadataModelType() {
        return this.modelType;
    }

    public boolean isDataEmpty() {
        return this.data.isEmpty();
    }

    public void putData(String key, Object value) {
        DefaultFXMLValidator.requireNonNullAndNotEmpty(key);
        DefaultFXMLValidator.requireNonNull(value);
        this.data.put(key, value);
    }

    public void setMetadataEntity(Class entity, Long entityId) {
        DefaultFXMLValidator.requireNonNull(entity);
        DefaultFXMLValidator.requireNonNull(entityId);
        this.entity = Optional.of(entity);
        this.entityId = Optional.of(entityId);
    }

    public void setMetadataEntity(Class entity, Long entityId, String modelType) {
        DefaultFXMLValidator.requireNonNull(entity);
        DefaultFXMLValidator.requireNonNull(entityId);
        DefaultFXMLValidator.requireNonNullAndNotEmpty(modelType);
        this.entity = Optional.of(entity);
        this.entityId = Optional.of(entityId);
        this.modelType = Optional.of(modelType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FXMLModel [\n");
        sb.append("  metadata [\n");
        sb.append("    entity    = ").append(this.entity.isPresent() ? this.entity.get().getName() : "<not-defined>").append(",\n");
        sb.append("    entityId  = ").append(this.entityId.isPresent() ? this.entityId.get() : "<not-defined>").append(",\n");
        sb.append("    modelType = ").append(this.modelType.isPresent() ? this.modelType.get() : "<not-defined>").append(",\n");
        sb.append("  ],\n");
        sb.append("  data [\n");
        Iterator<Map.Entry<String, Object>> iterator = this.data.entrySet().iterator();
        if (!iterator.hasNext()) {
            sb.append("    <not-defined>\n");
        }
        int maxLength = 0;
        for (String key : this.data.keySet()) {
            maxLength = Math.max(maxLength, key.length());
        }
        int elements = this.data.size();
        int counter = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String key = next.getKey();
            Object value = next.getValue();
            sb.append("    ").append(String.format("%-" + maxLength + "s", key));
            sb.append(" = ").append(value);
            sb.append(++counter < elements ? ",\n" : "\n");
        }
        sb.append("  ]\n");
        sb.append("]");
        return sb.toString();
    }
}

