/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentProxyException;
import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.FileChannelFactory;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class WindowsSSHAgentConnector
implements AgentConnector {
    private static final String DEFAULT_OPENSSH_AGENT_NAMED_PIPE = "\\\\.\\pipe\\openssh-ssh-agent";
    private static final int MAX_AGENT_REPLY_LEN = 262144;
    private final FileChannelFactory fileChannelFactory;
    private final String sshAgentNamedPipe;

    public WindowsSSHAgentConnector() {
        this(path -> new RandomAccessFile(path, "rw").getChannel(), DEFAULT_OPENSSH_AGENT_NAMED_PIPE);
    }

    public WindowsSSHAgentConnector(String sshAgentNamedPipe) {
        this(path -> new RandomAccessFile(path, "rw").getChannel(), sshAgentNamedPipe);
    }

    public WindowsSSHAgentConnector(FileChannelFactory fileChannelFactory) {
        this(fileChannelFactory, DEFAULT_OPENSSH_AGENT_NAMED_PIPE);
    }

    public WindowsSSHAgentConnector(FileChannelFactory fileChannelFactory, String sshAgentNamedPipe) {
        this.fileChannelFactory = fileChannelFactory;
        this.sshAgentNamedPipe = sshAgentNamedPipe;
    }

    @Override
    public String getName() {
        return "ssh-agent - Windows Named Pipe";
    }

    @Override
    public boolean isAvailable() {
        boolean bl;
        block8: {
            FileChannel fileChannel = this.open();
            try {
                bl = fileChannel.isOpen();
                if (fileChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            fileChannel.close();
        }
        return bl;
    }

    @Override
    public void query(Buffer buffer) throws AgentProxyException {
        try (FileChannel fileChannel = this.open();){
            WindowsSSHAgentConnector.writeFull(fileChannel, buffer, 0, buffer.getLength());
            buffer.rewind();
            int i = WindowsSSHAgentConnector.readFull(fileChannel, buffer, 0, 4);
            i = buffer.getInt();
            if (i <= 0 || i > 262144) {
                throw new AgentProxyException("Illegal length: " + i);
            }
            buffer.rewind();
            buffer.checkFreeSize(i);
            int n = WindowsSSHAgentConnector.readFull(fileChannel, buffer, 0, i);
        }
        catch (IOException e) {
            throw new AgentProxyException("I/O error communicating with OpenSSH agent: " + e.getMessage(), e);
        }
    }

    private FileChannel open() throws IOException {
        return this.fileChannelFactory.open(this.sshAgentNamedPipe);
    }

    private static int readFull(FileChannel fileChannel, Buffer buffer, int s, int len) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buffer.buffer, s, len);
        int _len = len;
        while (len > 0) {
            int j = fileChannel.read(bb);
            if (j < 0) {
                return -1;
            }
            if (j <= 0) continue;
            len -= j;
        }
        return _len;
    }

    private static int writeFull(FileChannel fileChannel, Buffer buffer, int s, int len) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buffer.buffer, s, len);
        int _len = len;
        while (len > 0) {
            int j = fileChannel.write(bb);
            if (j < 0) {
                return -1;
            }
            if (j <= 0) continue;
            len -= j;
        }
        return _len;
    }
}

