/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner.validation;

import com.github.mvp4g.mvp4g2.core.eventbus.IsEventBus;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Event;
import com.github.mvp4g.mvp4g2.core.history.annotation.InitHistory;
import com.github.mvp4g.mvp4g2.core.history.annotation.NotFoundHistory;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class EventAnnotationValidator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;
    private EventBusMetaModel eventBusMetaModel;
    private TypeElement eventBusTypeElement;

    private EventAnnotationValidator() {
    }

    private EventAnnotationValidator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.roundEnvironment = builder.roundEnvironment;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.eventBusTypeElement = builder.eventBusTypeElement;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() throws ProcessorException {
        ExecutableElement executableElement;
        ArrayList<String> historyNames = new ArrayList<String>();
        for (Element element : this.roundEnvironment.getElementsAnnotatedWith(Event.class)) {
            ExecutableElement eventExecutableElement;
            Event eventAnnotation = element.getAnnotation(Event.class);
            if (!this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), element.getEnclosingElement().asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsEventBus.class.getCanonicalName()).asType())) {
                throw new ProcessorException("Mvp4g2Processor: @Event can only be used inside a event bus! >>" + element.getEnclosingElement().toString() + "<< does no implement IsEventBus");
            }
            if (!"#%!|&*+!##%$".equals(eventAnnotation.historyName())) {
                if (historyNames.contains(eventAnnotation.historyName())) {
                    throw new ProcessorException("Mvp4g2Processor: EventElement: >>" + element.getSimpleName().toString() + "<< using a already used historyName -> >>" + eventAnnotation.historyName() + "<<");
                }
                historyNames.add(eventAnnotation.historyName());
            }
            if ("void".equals((eventExecutableElement = (ExecutableElement)element).getReturnType().toString())) continue;
            throw new ProcessorException("Mvp4g2Processor: EventElement: >>" + element.getSimpleName().toString() + "<< must return 'void'");
        }
        if (this.roundEnvironment.getElementsAnnotatedWith(InitHistory.class).size() > 1) {
            throw new ProcessorException("Mvp4g2Processor: @InitHistory can only be set a single time inside a event bus");
        }
        if (this.roundEnvironment.getElementsAnnotatedWith(InitHistory.class).size() == 1) {
            for (Element element : this.roundEnvironment.getElementsAnnotatedWith(InitHistory.class)) {
                executableElement = (ExecutableElement)element;
                if (((ExecutableElement)element).getParameters().size() <= 0) continue;
                throw new ProcessorException("Mvp4g2Processor: @InitHistory can only be used on a method with no arguments");
            }
        }
        if (this.roundEnvironment.getElementsAnnotatedWith(NotFoundHistory.class).size() > 1) {
            throw new ProcessorException("Mvp4g2Processor: @NotFoundHistory can only be set a single time inside a event bus");
        }
        if (this.roundEnvironment.getElementsAnnotatedWith(NotFoundHistory.class).size() == 1) {
            for (Element element : this.roundEnvironment.getElementsAnnotatedWith(NotFoundHistory.class)) {
                executableElement = (ExecutableElement)element;
                if (((ExecutableElement)element).getParameters().size() <= 0) continue;
                throw new ProcessorException("Mvp4g2Processor: @NotFoundHistory can only be used on a method with no arguments");
            }
        }
    }

    public void validate(Element element) throws ProcessorException {
        List<String> bindHandlerClasses;
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getAnnotation(Event.class).passive() && (bindHandlerClasses = this.getElementsFromAnnotationAsList(executableElement, "bind")).size() > 0) {
            throw new ProcessorException("Mvp4g2Processor: Event: >>" + executableElement.getSimpleName() + "<< a passive event can not have a bind-attribute");
        }
    }

    private List<String> getElementsFromAnnotationAsList(ExecutableElement executableElement, String attribute) {
        TypeElement eventAnnotation = this.processingEnvironment.getElementUtils().getTypeElement(Event.class.getName());
        TypeMirror eventAnnotationAsTypeMirror = eventAnnotation.asType();
        return executableElement.getAnnotationMirrors().stream().filter(annotationMirror -> annotationMirror.getAnnotationType().equals(eventAnnotationAsTypeMirror)).flatMap(annotationMirror -> annotationMirror.getElementValues().entrySet().stream()).filter(entry -> attribute.equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).findFirst().map(entry -> Arrays.stream(((AnnotationValue)entry.getValue()).toString().replace("{", "").replace("}", "").replace(" ", "").split(",")).map(v -> v.substring(0, v.indexOf(".class"))).collect(Collectors.toList())).orElse(null);
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        RoundEnvironment roundEnvironment;
        TypeElement eventBusTypeElement;
        EventBusMetaModel eventBusMetaModel;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder roundEnvironment(RoundEnvironment roundEnvironment) {
            this.roundEnvironment = roundEnvironment;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public Builder eventBusTypeElement(TypeElement eventBusTypeElement) {
            this.eventBusTypeElement = eventBusTypeElement;
            return this;
        }

        public EventAnnotationValidator build() {
            return new EventAnnotationValidator(this);
        }
    }
}

