/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner.validation;

import com.github.mvp4g.mvp4g2.core.eventbus.IsEventBus;
import com.github.mvp4g.mvp4g2.core.eventbus.IsMvp4g2Logger;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Debug;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;

public class DebugAnnotationValidator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;

    private DebugAnnotationValidator() {
    }

    private DebugAnnotationValidator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.roundEnvironment = builder.roundEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() throws ProcessorException {
        Set<? extends Element> elementsWithDebugAnnotation = this.roundEnvironment.getElementsAnnotatedWith(Debug.class);
        if (elementsWithDebugAnnotation.size() > 1) {
            throw new ProcessorException("There should be at least only one interface, that is annotated with @Debug");
        }
        for (Element element : elementsWithDebugAnnotation) {
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                if (!typeElement.getKind().isInterface()) {
                    throw new ProcessorException("@Debug can only be used with an interface");
                }
                if (!this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsEventBus.class.getCanonicalName()).asType())) {
                    throw new ProcessorException("@Debug can only be used on interfaces that extends IsEventBus");
                }
                TypeElement loggerElement = this.getLogger(typeElement.getAnnotation(Debug.class));
                if (this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), loggerElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsMvp4g2Logger.class.getCanonicalName()).asType())) continue;
                throw new ProcessorException("@Debug - the logger attribute needs class that extends IsMvp4g2Logger");
            }
            throw new ProcessorException("@Debug can only be used on a type (interface)");
        }
    }

    private TypeElement getLogger(Debug debugAnnotation) {
        try {
            debugAnnotation.logger();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        RoundEnvironment roundEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder roundEnvironment(RoundEnvironment roundEnvironment) {
            this.roundEnvironment = roundEnvironment;
            return this;
        }

        public DebugAnnotationValidator build() {
            return new DebugAnnotationValidator(this);
        }
    }
}

