/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.ui.annotation.Handler;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.HandlerMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.HandlerAnnotationValidator;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class HandlerAnnotationScanner {
    private static final String HANDLER_PROPERTIES = "handler.properties";
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private HandlerAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public HandlerMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        HandlerAnnotationValidator validator = HandlerAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).build();
        HandlerMetaModel model = this.restore();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Handler.class)) {
            TypeElement typeElement = (TypeElement)element;
            validator.validate(typeElement);
            model.add(((TypeElement)element).getQualifiedName().toString(), this.processorUtils.createHandledEventArray(typeElement));
        }
        this.processorUtils.store(model, this.createRelativeFileName());
        return model;
    }

    private HandlerMetaModel restore() {
        Properties props = new Properties();
        try {
            FileObject resource = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.createRelativeFileName());
            props.load(resource.openInputStream());
            return new HandlerMetaModel(props);
        }
        catch (IOException iOException) {
            return new HandlerMetaModel();
        }
    }

    private String createRelativeFileName() {
        return "META-INF/mvp4g2/handler.properties";
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public HandlerAnnotationScanner build() {
            return new HandlerAnnotationScanner(this);
        }
    }
}

