/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.model;

import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.IsMetaModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class HistoryMetaModel
implements IsMetaModel {
    private static final String KEY_HISTORY_CONVERTERS = "historyConverters";
    private static final String KEY_HISTORY_CONVERTER = ".historyConverter";
    private static final String KEY_HISTORY_CONVERTER_TYPE = ".historyConverterType";
    private Map<String, HistoryData> historyDatas = new HashMap<String, HistoryData>();

    public HistoryMetaModel() {
        this.historyDatas = new HashMap<String, HistoryData>();
    }

    public HistoryMetaModel(Properties properties) {
        if (Objects.isNull(properties.getProperty(KEY_HISTORY_CONVERTERS))) {
            this.historyDatas = new HashMap<String, HistoryData>();
        } else if (properties.getProperty(KEY_HISTORY_CONVERTERS).trim().length() > 0) {
            Arrays.stream(properties.getProperty(KEY_HISTORY_CONVERTERS).split("\\s*,\\s*")).forEach(s -> this.historyDatas.put(properties.getProperty(s + KEY_HISTORY_CONVERTER), new HistoryData(properties.getProperty(s + KEY_HISTORY_CONVERTER), properties.getProperty(s + KEY_HISTORY_CONVERTER_TYPE))));
        }
    }

    public void add(String historyConverter, String historyConverterType) {
        this.historyDatas.put(historyConverter, new HistoryData(historyConverter, historyConverterType));
    }

    public Set<String> getHistoryConverterClassNames() {
        return this.historyDatas.keySet();
    }

    public HistoryData getHistoryData(String key) {
        return this.historyDatas.get(key);
    }

    @Override
    public Properties createPropertes() {
        Properties props = new Properties();
        props.setProperty(KEY_HISTORY_CONVERTERS, String.join((CharSequence)",", this.historyDatas.keySet()));
        this.historyDatas.values().stream().forEach(data -> {
            props.setProperty(((HistoryData)data).historyConverter.getClassName() + KEY_HISTORY_CONVERTER, ((HistoryData)data).historyConverter.getClassName());
            props.setProperty(((HistoryData)data).historyConverter.getClassName() + KEY_HISTORY_CONVERTER_TYPE, ((HistoryData)data).historyConverterType);
        });
        return props;
    }

    public class HistoryData {
        private ClassNameModel historyConverter;
        private String historyConverterType;

        public HistoryData(String historyConverter, String historyConverterType) {
            this.historyConverter = new ClassNameModel(historyConverter);
            this.historyConverterType = historyConverterType;
        }

        public ClassNameModel getHistoryConverter() {
            return this.historyConverter;
        }

        public String getHistoryConverterType() {
            return this.historyConverterType;
        }
    }
}

