/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;

public class FilterGenerator {
    private EventBusMetaModel eventBusMetaModel;
    private TypeSpec.Builder typeSpec;

    private FilterGenerator() {
    }

    private FilterGenerator(Builder builder) {
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.typeSpec = builder.typeSpec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate() throws ProcessorException {
        MethodSpec.Builder loadFilterConfigurationMethod = MethodSpec.methodBuilder((String)"loadFilterConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.eventBusMetaModel.hasFiltersAnnotation()) {
            loadFilterConfigurationMethod.addStatement("super.setFiltersEnable(true)", new Object[0]);
            this.eventBusMetaModel.getFilters().stream().forEach(filterClassName -> loadFilterConfigurationMethod.addStatement("super.eventFilters.add(new $T())", new Object[]{ClassName.get((String)filterClassName.getPackage(), (String)filterClassName.getSimpleName(), (String[])new String[0])}));
        } else {
            loadFilterConfigurationMethod.addStatement("super.setFiltersEnable(false)", new Object[0]);
        }
        this.typeSpec.addMethod(loadFilterConfigurationMethod.build());
    }

    public static final class Builder {
        EventBusMetaModel eventBusMetaModel;
        TypeSpec.Builder typeSpec;

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public Builder typeSpec(TypeSpec.Builder typeSpec) {
            this.typeSpec = typeSpec;
            return this;
        }

        public FilterGenerator build() {
            return new FilterGenerator(this);
        }
    }
}

