/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor;

import com.github.mvp4g.mvp4g2.core.application.annotation.Application;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Debug;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Event;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.EventBus;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Filters;
import com.github.mvp4g.mvp4g2.core.history.annotation.History;
import com.github.mvp4g.mvp4g2.core.ui.annotation.EventHandler;
import com.github.mvp4g.mvp4g2.core.ui.annotation.Handler;
import com.github.mvp4g.mvp4g2.core.ui.annotation.Presenter;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.generator.ApplicationGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.EventBusGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.HandlerGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.HistoryGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.PresenterGenerator;
import com.github.mvp4g.mvp4g2.processor.model.ApplicationMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HandlerMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HistoryMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.ApplicationAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.EventBusAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.HandlerAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.HistoryAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.PresenterAnnotationScanner;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.ModelValidator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class Mvp4g2Processor
extends AbstractProcessor {
    private ProcessorUtils processorUtils;
    private ApplicationAnnotationScanner applicationAnnotationScanner;
    private EventBusAnnotationScanner eventBusAnnotationScanner;
    private HandlerAnnotationScanner handlerAnnotationScanner;
    private HistoryAnnotationScanner historyAnnotationScanner;
    private PresenterAnnotationScanner presenterAnnotationScanner;
    private ApplicationGenerator applicationGenerator;
    private EventBusGenerator eventBusGenerator;
    private HandlerGenerator handlerGenerator;
    private HistoryGenerator historyGenerator;
    private PresenterGenerator presenterGenerator;
    private ApplicationMetaModel applicationMetaModel;
    private EventBusMetaModel eventBusMetaModel;
    private HandlerMetaModel handlerMetaModel;
    private HistoryMetaModel historyMetaModel;
    private PresenterMetaModel presenterMetaModel;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.of(Application.class.getCanonicalName(), Debug.class.getCanonicalName(), Event.class.getCanonicalName(), EventBus.class.getCanonicalName(), EventHandler.class.getCanonicalName(), Filters.class.getCanonicalName(), Handler.class.getCanonicalName(), History.class.getCanonicalName(), Presenter.class.getCanonicalName()).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.setUp(roundEnv);
        this.processorUtils.createNoteMessage("Mvp4g2-Processor triggered: " + System.currentTimeMillis());
        try {
            if (roundEnv.processingOver()) {
                this.generate();
            } else {
                this.scan(roundEnv);
                this.validateModels(roundEnv);
            }
            return false;
        }
        catch (ProcessorException e) {
            this.processorUtils.createErrorMessage(e.getMessage());
            return false;
        }
    }

    private void setUp(RoundEnvironment roundEnv) {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnv).build();
        this.applicationAnnotationScanner = ApplicationAnnotationScanner.builder().roundEnvironment(roundEnv).processingEnvironment(this.processingEnv).build();
        this.eventBusAnnotationScanner = EventBusAnnotationScanner.builder().roundEnvironment(roundEnv).processingEnvironment(this.processingEnv).build();
        this.handlerAnnotationScanner = HandlerAnnotationScanner.builder().processingEnvironment(this.processingEnv).build();
        this.historyAnnotationScanner = HistoryAnnotationScanner.builder().processingEnvironment(this.processingEnv).build();
        this.presenterAnnotationScanner = PresenterAnnotationScanner.builder().processingEnvironment(this.processingEnv).build();
        this.applicationGenerator = ApplicationGenerator.builder().processingEnvironment(this.processingEnv).build();
        this.eventBusGenerator = EventBusGenerator.builder().processingEnvironment(this.processingEnv).build();
        this.handlerGenerator = HandlerGenerator.builder().processingEnvironment(this.processingEnv).build();
        this.historyGenerator = HistoryGenerator.builder().processingEnvironment(this.processingEnv).build();
        this.presenterGenerator = PresenterGenerator.builder().processingEnvironment(this.processingEnv).build();
    }

    private void generate() throws ProcessorException {
        if (!Objects.isNull(this.applicationMetaModel)) {
            this.applicationGenerator.generate(this.applicationMetaModel);
        }
        if (!Objects.isNull(this.handlerMetaModel)) {
            this.handlerGenerator.generate(this.handlerMetaModel);
        }
        if (!Objects.isNull(this.presenterMetaModel)) {
            this.presenterGenerator.generate(this.presenterMetaModel);
        }
        if (!Objects.isNull(this.historyMetaModel)) {
            this.historyGenerator.generate(this.historyMetaModel);
        }
        if (!Objects.isNull(this.eventBusMetaModel)) {
            this.eventBusGenerator.generate(this.eventBusMetaModel, this.handlerMetaModel, this.presenterMetaModel, this.historyMetaModel);
        }
    }

    private void scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        this.applicationMetaModel = this.applicationAnnotationScanner.scan(roundEnvironment);
        this.handlerMetaModel = this.handlerAnnotationScanner.scan(roundEnvironment);
        this.presenterMetaModel = this.presenterAnnotationScanner.scan(roundEnvironment);
        this.historyMetaModel = this.historyAnnotationScanner.scan(roundEnvironment);
        this.eventBusMetaModel = this.eventBusAnnotationScanner.scan(roundEnvironment);
    }

    private void validateModels(RoundEnvironment roundEnv) throws ProcessorException {
        ModelValidator.builder().processorUtils(this.processorUtils).eventBusMetaModel(this.eventBusMetaModel).handlerMetaModel(this.handlerMetaModel).presenterMetaModel(this.presenterMetaModel).build().validate();
    }
}

