/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.security;

import com.ibm.mqlight.api.impl.LogbackLogging;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.security.PemFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import org.apache.commons.ssl.PKCS8Key;

public class KeyStoreUtils {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadKeyStore(File file, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        block14: {
            String methodName = "loadKeyStore";
            logger.entry("loadKeyStore", file);
            String fileName = file.getName();
            if (fileName.matches("(?i).*\\.jks")) {
                keyStore = KeyStore.getInstance("JKS");
            } else if (fileName.matches("(?i).*\\.jceks")) {
                keyStore = KeyStore.getInstance("JCEKS");
            } else if (fileName.matches("(?i).*\\.p12") || fileName.matches("(?i).*\\.pkcs12")) {
                keyStore = KeyStore.getInstance("PKCS12");
            } else if (fileName.matches("(?i).*\\.kdb")) {
                keyStore = KeyStore.getInstance("CMSKS");
            } else {
                String keyStoreType = KeyStore.getDefaultType();
                keyStore = KeyStore.getInstance(keyStoreType);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                char[] passwordChars = password == null ? null : password.toCharArray();
                keyStore.load(fileInputStream, passwordChars);
                if (fileInputStream == null) break block14;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    logger.data("loadKeyStore", "failed to close file: ", file, " reason", e);
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                logger.data("loadKeyStore", "failed to close file: ", file, " reason", e);
            }
        }
        logger.exit("loadKeyStore", keyStore);
        return keyStore;
    }

    public static void addPrivateKey(KeyStore keyStore, File pemKeyFile, char[] passwordChars, List<Certificate> certChain) throws IOException, GeneralSecurityException {
        String methodName = "addPrivateKey";
        logger.entry("addPrivateKey", pemKeyFile, certChain);
        PrivateKey privateKey = KeyStoreUtils.createPrivateKey(pemKeyFile, passwordChars);
        keyStore.setKeyEntry("key", privateKey, passwordChars, certChain.toArray(new Certificate[certChain.size()]));
        logger.exit("addPrivateKey");
    }

    public static PrivateKey createPrivateKey(File pemKeyFile, char[] passwordChars) throws IOException, GeneralSecurityException {
        PrivateKey privateKey;
        String methodName = "createPrivateKey";
        logger.entry("createPrivateKey", pemKeyFile);
        PemFile privateKeyPemFile = new PemFile(pemKeyFile);
        byte[] privateKeyBytes = privateKeyPemFile.getPrivateKeyBytes();
        if (privateKeyPemFile.containsEncryptedPrivateKey()) {
            PKCS8Key key = new PKCS8Key(privateKeyBytes, passwordChars);
            privateKey = key.getPrivateKey();
        } else {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            InvalidKeySpecException keyFactoryException = null;
            PrivateKey key = null;
            for (String alg : new String[]{"RSA", "DSA", "DiffieHellman", "EC"}) {
                try {
                    key = KeyFactory.getInstance(alg).generatePrivate(keySpec);
                    break;
                }
                catch (InvalidKeySpecException e) {
                    if (keyFactoryException != null) continue;
                    keyFactoryException = e;
                }
            }
            if (key == null) {
                throw keyFactoryException;
            }
            privateKey = key;
        }
        logger.exit("createPrivateKey", privateKey);
        return privateKey;
    }

    static {
        LogbackLogging.setup();
    }
}

