/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.network.ssl;

import com.ibm.mqlight.api.ClientOptions;
import com.ibm.mqlight.api.impl.LogbackLogging;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.security.KeyStoreUtils;
import com.ibm.mqlight.api.security.PemFile;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public class SSLEngineFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLEngineFactory.class);
    final Pattern disabledProtocolPattern = Pattern.compile("(SSLv2|SSLv3).*");
    final Pattern disabledCipherPattern = Pattern.compile(".*_(NULL|EXPORT|DES|RC4|MD5|PSK|SRP|CAMELLIA)_.*");

    public static SSLEngineFactory newInstance() {
        return new SSLEngineFactory();
    }

    private SSLEngineFactory() {
    }

    public SSLEngine createClientSSLEngine(ClientOptions.SSLOptions sslOptions, String host, int port) throws SSLException, NoSuchAlgorithmException, KeyManagementException {
        KeyStore keyStore;
        String methodName = "createClientSSLEngine";
        logger.entry(this, "createClientSSLEngine", sslOptions, host, port);
        KeyManagerFactory keyManagerFactory = null;
        TrustManagerFactory trustManagerFactory = null;
        File keyStoreFile = sslOptions.getKeyStoreFile();
        if (keyStoreFile != null) {
            try {
                keyStore = KeyStoreUtils.loadKeyStore(keyStoreFile, sslOptions.getKeyStoreFilePassphrase());
                keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, sslOptions.getKeyStoreFilePassphrase().toCharArray());
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new SSLException("failed to load key store", e);
            }
        }
        if (sslOptions.getClientCertificateFile() != null && sslOptions.getClientCertificateFile().exists()) {
            try {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null, null);
                char[] clientKeyPasswordChars = sslOptions.getClientKeyFilePassphrase() == null ? Long.toHexString(new SecureRandom().nextLong()).toCharArray() : sslOptions.getClientKeyFilePassphrase().toCharArray();
                PemFile certChainPemFile = new PemFile(sslOptions.getClientCertificateFile());
                List<Certificate> certChain = certChainPemFile.getCertificates();
                KeyStoreUtils.addPrivateKey(keyStore, sslOptions.getClientKeyFile(), clientKeyPasswordChars, certChain);
                keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, clientKeyPasswordChars);
            }
            catch (Exception e) {
                throw new SSLException("failed to load client certificate or private key", e);
            }
        }
        if (sslOptions.getTrustCertificateFile() != null && sslOptions.getTrustCertificateFile().exists()) {
            try {
                KeyStore trustStore = null;
                try {
                    trustStore = KeyStoreUtils.loadKeyStore(sslOptions.getTrustCertificateFile(), null);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    logger.data(this, "createClientSSLEngine", e.toString());
                    trustStore = null;
                }
                if (trustStore == null) {
                    trustStore = KeyStore.getInstance("JKS");
                    trustStore.load(null, null);
                    PemFile certsPemFile = new PemFile(sslOptions.getTrustCertificateFile());
                    List<Certificate> certs = certsPemFile.getCertificates();
                    int index = 0;
                    for (Certificate cert : certs) {
                        trustStore.setCertificateEntry("cert" + ++index, cert);
                    }
                }
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
            }
            catch (Exception e) {
                throw new SSLException("failed to load trust certificates", e);
            }
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers(), null);
        final SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        sslEngine.setUseClientMode(true);
        LinkedList<String> enabledProtocols = new LinkedList<String>(){
            private static final long serialVersionUID = 7838479468739671083L;
            {
                for (String protocol : sslEngine.getSupportedProtocols()) {
                    if (SSLEngineFactory.this.disabledProtocolPattern.matcher(protocol).matches()) continue;
                    this.add(protocol);
                }
            }
        };
        sslEngine.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
        logger.data(this, "createClientSSLEngine", "enabledProtocols", Arrays.toString(sslEngine.getEnabledProtocols()));
        LinkedList<String> enabledCipherSuites = new LinkedList<String>(){
            private static final long serialVersionUID = 7838479468739671083L;
            {
                for (String cipher : sslEngine.getSupportedCipherSuites()) {
                    if (SSLEngineFactory.this.disabledCipherPattern.matcher(cipher).matches()) continue;
                    this.add(cipher);
                }
            }
        };
        sslEngine.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]));
        logger.data(this, "createClientSSLEngine", "enabledCipherSuites", Arrays.toString(sslEngine.getEnabledCipherSuites()));
        if (sslOptions.getVerifyName()) {
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
        }
        logger.exit(this, "createClientSSLEngine", sslEngine);
        return sslEngine;
    }

    static {
        LogbackLogging.setup();
    }
}

