/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.network;

import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.network.ConnectionError;
import com.ibm.mqlight.api.impl.network.DataRead;
import com.ibm.mqlight.api.network.NetworkChannel;
import com.ibm.mqlight.api.network.NetworkListener;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class NetworkListenerImpl
implements NetworkListener {
    private final Component component;

    public NetworkListenerImpl(Component component) {
        this.component = component;
    }

    @Override
    public void onRead(NetworkChannel channel, ByteBuf buffer) {
        this.component.tell(new DataRead(channel, buffer), ComponentImpl.NOBODY);
    }

    @Override
    public void onClose(NetworkChannel channel) {
        this.component.tell(new ConnectionError(channel, new IOException("Network connection closed by server")), ComponentImpl.NOBODY);
    }

    @Override
    public void onError(NetworkChannel channel, Exception exception) {
        this.component.tell(new ConnectionError(channel, exception), ComponentImpl.NOBODY);
    }
}

