/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.network;

import com.ibm.mqlight.api.ClientException;
import com.ibm.mqlight.api.NetworkException;
import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.network.ConnectResponse;
import com.ibm.mqlight.api.impl.network.NetworkClosePromiseImpl;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.network.NetworkChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public class NetworkConnectPromiseImpl
implements Promise<NetworkChannel> {
    private static final Logger logger = LoggerFactory.getLogger(NetworkClosePromiseImpl.class);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Component component;
    private final Object context;
    private NetworkChannel channel;

    public NetworkConnectPromiseImpl(Component component, Object context) {
        String methodName = "<init>";
        logger.entry(this, "<init>", component, context);
        this.component = component;
        this.context = context;
        logger.exit(this, "<init>");
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSuccess(NetworkChannel channel) throws IllegalStateException {
        String methodName = "setSuccess";
        logger.entry(this, "setSuccess", channel);
        if (this.complete.getAndSet(true)) {
            IllegalStateException exception = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setSuccess", exception);
            throw exception;
        }
        NetworkConnectPromiseImpl networkConnectPromiseImpl = this;
        synchronized (networkConnectPromiseImpl) {
            this.channel = channel;
        }
        this.component.tell(new ConnectResponse(channel, null, this.context), ComponentImpl.NOBODY);
        logger.exit(this, "setSuccess");
    }

    @Override
    public void setFailure(Exception exception) throws IllegalStateException {
        String methodName = "setFailure";
        logger.entry(this, "setFailure", exception);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setFailure", ex);
            throw ex;
        }
        ClientException clientException = exception instanceof ClientException ? (ClientException)exception : new NetworkException("The network operation failed.  See linked exception for more information", exception);
        this.component.tell(new ConnectResponse(this.getChannel(), clientException, this.context), ComponentImpl.NOBODY);
        logger.exit(this, "setFailure");
    }

    public synchronized NetworkChannel getChannel() {
        return this.channel;
    }

    public Object getContext() {
        return this.context;
    }
}

