/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.network;

import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.network.DisconnectResponse;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class NetworkClosePromiseImpl
implements Promise<Void> {
    private static final Logger logger = LoggerFactory.getLogger(NetworkClosePromiseImpl.class);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Component component;
    private final Object context;

    public NetworkClosePromiseImpl(Component component, Object context) {
        String methodName = "<init>";
        logger.entry(this, "<init>", component, context);
        this.component = component;
        this.context = context;
        logger.exit(this, "<init>");
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public void setSuccess(Void x) throws IllegalStateException {
        String methodName = "setSuccess";
        logger.entry(this, "setSuccess", x);
        if (this.complete.getAndSet(true)) {
            IllegalStateException exception = new IllegalStateException("Promise already completed");
            logger.ffdc("setSuccess", FFDCProbeId.PROBE_001, exception, this);
            logger.throwing(this, "setSuccess", exception);
            throw exception;
        }
        this.component.tell(new DisconnectResponse(this.context), ComponentImpl.NOBODY);
        logger.exit(this, "setSuccess");
    }

    @Override
    public void setFailure(Exception exception) throws IllegalStateException {
        String methodName = "setFailure";
        logger.entry(this, "setFailure", exception);
        logger.ffdc("setFailure", FFDCProbeId.PROBE_002, new Exception("should never be called"), this);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.ffdc("setFailure", FFDCProbeId.PROBE_003, ex, this);
            logger.throwing(this, "setFailure", ex);
            throw ex;
        }
        logger.exit(this, "setFailure");
    }
}

