/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.logging;

import com.ibm.mqlight.api.impl.logging.Javacore;
import com.ibm.mqlight.api.impl.logging.LogMarker;
import com.ibm.mqlight.api.impl.logging.Version;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;

class FFDC {
    private static final String lineSeparator = System.getProperty("line.separator");

    FFDC() {
    }

    public static void capture(Logger logger, String methodName, FFDCProbeId probe, Throwable throwable, Object ... data) {
        FFDC.capture(logger, null, methodName, probe, throwable, data);
    }

    public static void capture(Logger logger, Object callingObject, String methodName, FFDCProbeId probeId, Throwable throwable, Object[] data) {
        long ffdcTimestamp = System.currentTimeMillis();
        String className = logger.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("Level:      ");
        sb.append(Version.getVersion());
        sb.append(lineSeparator);
        SimpleDateFormat recordFormatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS z");
        sb.append("Time:       ");
        sb.append(recordFormatter.format(ffdcTimestamp));
        sb.append(lineSeparator);
        Thread currentThread = Thread.currentThread();
        sb.append("Thread:     ");
        sb.append(currentThread.getId());
        sb.append(" (");
        sb.append(currentThread.getName());
        sb.append(")");
        sb.append(lineSeparator);
        if (className != null) {
            sb.append("Class:      ");
            sb.append(className);
            sb.append(lineSeparator);
        }
        if (callingObject != null) {
            sb.append("Instance:   ");
            sb.append(Integer.toHexString(System.identityHashCode(callingObject)));
            sb.append(lineSeparator);
        }
        if (methodName != null) {
            sb.append("Method:     ");
            sb.append(methodName);
            sb.append(lineSeparator);
        }
        sb.append("Probe:      ");
        sb.append(probeId == null ? "null" : probeId);
        sb.append(lineSeparator);
        sb.append("Cause:      ");
        sb.append(throwable == null ? "null" : throwable.toString());
        sb.append(lineSeparator);
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream((OutputStream)byteOut, false, "UTF-8");
            Throwable displayThrowable = throwable != null ? throwable : new Exception("Call stack");
            displayThrowable.printStackTrace(stream);
            stream.flush();
            sb.append(byteOut.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to generate FFDC call stack. Reason: ", (Object)e.getLocalizedMessage());
        }
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                Object item = data[i];
                sb.append("Arg[");
                sb.append(i);
                sb.append("]:     ");
                sb.append(item);
                sb.append(lineSeparator);
            }
        }
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            sb.append(FFDC.getThreadInfo(thread));
        }
        logger.error(LogMarker.FFDC.getValue(), sb.toString());
        try {
            String javacoreFilePath = Javacore.generateJavaCore();
            logger.info("Javacore diagnostic information written to: " + javacoreFilePath);
        }
        catch (Throwable e) {
            logger.error("Failed to generate a javacore. Reason: {}", (Object)e.getLocalizedMessage());
        }
    }

    private static String getThreadInfo(Thread thread) {
        StringBuilder sb = new StringBuilder();
        sb.append("Thread:     ");
        sb.append(thread.getId());
        sb.append(" (");
        sb.append(thread.getName());
        sb.append(")");
        sb.append(lineSeparator);
        StackTraceElement[] stack = thread.getStackTrace();
        if (stack.length == 0) {
            sb.append("        No Java callstack associated with this thread");
            sb.append(lineSeparator);
        } else {
            for (StackTraceElement element : stack) {
                sb.append("        at ");
                sb.append(element.getClassName());
                sb.append(".");
                sb.append(element.getMethodName());
                sb.append("(");
                int lineNumber = element.getLineNumber();
                if (lineNumber == -2) {
                    sb.append("Native Method");
                } else if (lineNumber >= 0) {
                    sb.append(element.getFileName());
                    sb.append(":");
                    sb.append(element.getLineNumber());
                } else {
                    sb.append(element.getFileName());
                }
                sb.append(")");
                sb.append(lineSeparator);
            }
        }
        sb.append(lineSeparator);
        return sb.toString();
    }
}

