/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.engine;

import com.ibm.mqlight.api.ClientException;
import com.ibm.mqlight.api.NetworkException;
import com.ibm.mqlight.api.NotPermittedException;
import com.ibm.mqlight.api.QOS;
import com.ibm.mqlight.api.ReplacedException;
import com.ibm.mqlight.api.SecurityException;
import com.ibm.mqlight.api.StateException;
import com.ibm.mqlight.api.SubscribedException;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.Message;
import com.ibm.mqlight.api.impl.SubscriptionTopic;
import com.ibm.mqlight.api.impl.engine.CloseRequest;
import com.ibm.mqlight.api.impl.engine.CloseResponse;
import com.ibm.mqlight.api.impl.engine.DeliveryRequest;
import com.ibm.mqlight.api.impl.engine.DeliveryResponse;
import com.ibm.mqlight.api.impl.engine.DisconnectNotification;
import com.ibm.mqlight.api.impl.engine.DrainNotification;
import com.ibm.mqlight.api.impl.engine.EngineConnection;
import com.ibm.mqlight.api.impl.engine.OpenRequest;
import com.ibm.mqlight.api.impl.engine.OpenResponse;
import com.ibm.mqlight.api.impl.engine.SendRequest;
import com.ibm.mqlight.api.impl.engine.SendResponse;
import com.ibm.mqlight.api.impl.engine.SubscribeRequest;
import com.ibm.mqlight.api.impl.engine.SubscribeResponse;
import com.ibm.mqlight.api.impl.engine.UnsubscribeRequest;
import com.ibm.mqlight.api.impl.engine.UnsubscribeResponse;
import com.ibm.mqlight.api.impl.network.ConnectResponse;
import com.ibm.mqlight.api.impl.network.ConnectionError;
import com.ibm.mqlight.api.impl.network.DataRead;
import com.ibm.mqlight.api.impl.network.DisconnectResponse;
import com.ibm.mqlight.api.impl.network.NetworkClosePromiseImpl;
import com.ibm.mqlight.api.impl.network.NetworkConnectPromiseImpl;
import com.ibm.mqlight.api.impl.network.NetworkListenerImpl;
import com.ibm.mqlight.api.impl.network.NetworkWritePromiseImpl;
import com.ibm.mqlight.api.impl.network.WriteResponse;
import com.ibm.mqlight.api.impl.timer.PopResponse;
import com.ibm.mqlight.api.impl.timer.TimerPromiseImpl;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.network.NetworkService;
import com.ibm.mqlight.api.timer.TimerService;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.LinkError;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.framing.TransportFrame;

public class Engine
extends ComponentImpl
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(Engine.class);
    private final NetworkService network;
    private final TimerService timer;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> receiveScheduledFuture;
    private HashSet<Handler> children = new HashSet();

    public Engine(NetworkService network, TimerService timer) {
        String methodName = "<init>";
        logger.entry(this, "<init>", network, timer);
        if (network == null) {
            IllegalArgumentException exception = new IllegalArgumentException("NetworkService argument cannot be null");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        if (timer == null) {
            IllegalArgumentException exception = new IllegalArgumentException("TimerService argument cannot be null");
            logger.throwing(this, "<init>", exception);
            throw exception;
        }
        this.network = network;
        this.timer = timer;
        logger.exit(this, "<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void onReceive(Message message) {
        methodName = "onReceive";
        Engine.logger.entry(this, "onReceive", new Object[]{message});
        if (message instanceof OpenRequest) {
            or = (OpenRequest)message;
            listener = new NetworkListenerImpl(this);
            promise = new NetworkConnectPromiseImpl(this, or);
            this.network.connect(or.endpoint, listener, promise);
        } else if (message instanceof ConnectResponse) {
            cr = (ConnectResponse)message;
            or = (OpenRequest)cr.context;
            if (cr.exception != null) {
                or.getSender().tell(new OpenResponse(or, cr.exception), this);
            } else {
                protonConnection = Proton.connection();
                transport = Proton.transport();
                protocolTracer = new EngineProtocolTracer(or.clientId);
                ((TransportImpl)transport).setProtocolTracer(protocolTracer);
                transport.setIdleTimeout(or.endpoint.getIdleTimeout());
                transport.bind(protonConnection);
                collector = Proton.collector();
                protonConnection.setContainer(or.clientId);
                protonConnection.setHostname(or.endpoint.getHost());
                protonConnection.open();
                sasl = transport.sasl();
                sasl.client();
                if (or.endpoint.getUser() == null) {
                    sasl.setMechanisms(new String[]{"ANONYMOUS"});
                } else {
                    sasl.plain(or.endpoint.getUser(), or.endpoint.getPassword());
                }
                session = protonConnection.session();
                session.open();
                protonConnection.collect(collector);
                engineConnection = new EngineConnection(protonConnection, session, or.getSender(), transport, collector, cr.channel);
                engineConnection.openRequest = or;
                protonConnection.setContext(engineConnection);
                cr.channel.setContext(engineConnection);
                this.writeToNetwork(engineConnection);
            }
        } else if (message instanceof CloseRequest) {
            cr = (CloseRequest)message;
            protonConnection = cr.connection.connection;
            engineConnection = (EngineConnection)protonConnection.getContext();
            if (engineConnection.timerPromise != null) {
                tmp = engineConnection.timerPromise;
                engineConnection.timerPromise = null;
                this.timer.cancel(tmp);
            }
            protonConnection.close();
            engineConnection.closeRequest = cr;
            this.writeToNetwork(engineConnection);
        } else if (message instanceof SendRequest) {
            sr = (SendRequest)message;
            engineConnection = sr.connection;
            link = sr.connection.connection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE, EndpointState.UNINITIALIZED));
            linkOpened = false;
            while (true) {
                if (link == null) {
                    linkSender = sr.connection.session.sender(sr.topic);
                    source = new Source();
                    target = new Target();
                    source.setAddress(sr.topic);
                    target.setAddress(sr.topic);
                    linkSender.setSource(source);
                    linkSender.setTarget(target);
                    linkSender.open();
                    linkOpened = true;
                    break;
                }
                if (link instanceof Sender && sr.topic.equals(link.getName())) {
                    linkSender = (Sender)link;
                    break;
                }
                link = link.next(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE, EndpointState.UNINITIALIZED));
            }
            d = linkSender.delivery(String.valueOf(engineConnection.deliveryTag++).getBytes(Charset.forName("UTF-8")));
            linkSender.send(sr.buf.array(), 0, sr.length);
            if (sr.qos == QOS.AT_MOST_ONCE) {
                d.settle();
                if (!sr.retainLink) {
                    linkSender.close();
                    linkSender.free();
                }
            } else {
                engineConnection.inProgressOutboundDeliveries.put(d, sr);
            }
            linkSender.advance();
            engineConnection.drained = false;
            delta = engineConnection.transport.head().remaining();
            if (linkOpened) {
                delta += sr.length;
            }
            if (sr.qos == QOS.AT_MOST_ONCE) {
                engineConnection.addInflightQos0(delta, new SendResponse(sr, null), sr.getSender(), this);
            }
            this.writeToNetwork(engineConnection);
        } else if (message instanceof SubscribeRequest) {
            sr = (SubscribeRequest)message;
            engineConnection = sr.connection;
            if (engineConnection.subscriptionData.containsKey(sr.topic.toString())) {
                exception = new SubscribedException("Cannot subscribe because the client is already subscribed to topic " + sr.topic.toString());
                sr.getSender().tell(new SubscribeResponse(engineConnection, sr.topic, exception), this);
            } else {
                linkReceiver = sr.connection.session.receiver(sr.topic.getTopic());
                engineConnection.subscriptionData.put(sr.topic.toString(), new EngineConnection.SubscriptionData(sr.getSender(), sr.initialCredit, linkReceiver));
                source = new Source();
                source.setAddress(sr.topic.getTopic());
                target = new Target();
                target.setAddress(sr.topic.getTopic());
                if (sr.ttl > 0L) {
                    source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                    source.setTimeout(UnsignedInteger.valueOf(sr.ttl));
                    target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                    target.setTimeout(UnsignedInteger.valueOf(sr.ttl));
                }
                linkReceiver.setSource(source);
                linkReceiver.setTarget(target);
                if (sr.qos == QOS.AT_LEAST_ONCE) {
                    linkReceiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                    linkReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                } else {
                    linkReceiver.setSenderSettleMode(SenderSettleMode.SETTLED);
                    linkReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                }
                if (sr.topic.isShared()) {
                    source.setCapabilities(new Symbol[]{Symbol.valueOf("shared")});
                }
                linkReceiver.open();
                linkReceiver.flow(sr.initialCredit);
                this.writeToNetwork(engineConnection);
            }
        } else if (message instanceof UnsubscribeRequest) {
            ur = (UnsubscribeRequest)message;
            engineConnection = ur.connection;
            sd = engineConnection.subscriptionData.get(ur.topic.toString());
            t = (Target)sd.receiver.getTarget();
            s = (Source)sd.receiver.getSource();
            if (ur.zeroTtl) {
                t.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                t.setTimeout(new UnsignedInteger(0));
                s.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                s.setTimeout(new UnsignedInteger(0));
                sd.receiver.close();
            } else if (t.getExpiryPolicy() == TerminusExpiryPolicy.NEVER || t.getTimeout().longValue() > 0L || ur.topic.isShared()) {
                sd.receiver.detach();
            } else {
                sd.receiver.close();
            }
            this.writeToNetwork(engineConnection);
        } else if (message instanceof DeliveryResponse) {
            dr = (DeliveryResponse)message;
            delivery = dr.request.delivery;
            delivery.settle();
            engineConnection = (EngineConnection)dr.request.protonConnection.getContext();
            subData = engineConnection.subscriptionData.get(dr.request.topicPattern);
            if (subData == null) {
                if (dr.request.qos != QOS.AT_MOST_ONCE) {
                    throw new StateException("Client had unsubscribed from '" + dr.request.topicPattern + "' before delivery was confirmed");
                }
            } else {
                ++subData.settled;
                --subData.unsettled;
                available = subData.maxLinkCredit - subData.unsettled;
                if (available / (double)subData.settled <= 1.25 || subData.unsettled == 0 && subData.settled > 0) {
                    subData.receiver.flow(subData.settled);
                    subData.settled = 0;
                }
            }
            this.writeToNetwork(engineConnection);
            engineConnection.requestor.tell(message, this);
        } else if (message instanceof WriteResponse) {
            wr = (WriteResponse)message;
            engineConnection = (EngineConnection)wr.context;
            if (engineConnection != null) {
                engineConnection.bytesWritten += wr.amount;
                engineConnection.notifyInflightQos0(false);
                if (wr.drained && !engineConnection.drained) {
                    engineConnection.drained = true;
                    engineConnection.requestor.tell(new DrainNotification(), this);
                }
                if (engineConnection.transport.pending() > 0) {
                    this.writeToNetwork(engineConnection);
                }
            }
        } else if (message instanceof DataRead) {
            dr = (DataRead)message;
            try {
                engineConnection = (EngineConnection)dr.channel.getContext();
                if (engineConnection.closed || engineConnection.transport.isClosed()) ** GOTO lbl232
                while ((bytesAvailable = dr.buffer.readableBytes()) > 0) {
                    tail = engineConnection.transport.tail();
                    if (bytesAvailable > tail.remaining() && bytesAvailable > (max = tail.capacity() - tail.position())) {
                        bytesAvailable = max;
                    }
                    tail.limit(tail.position() + bytesAvailable);
                    dr.buffer.readBytes(tail);
                    engineConnection.transport.process();
                    this.process(engineConnection.collector);
                }
                this.writeToNetwork(engineConnection);
            }
            finally {
                dr.buffer.release();
            }
        } else if (message instanceof DisconnectResponse) {
            dr = (DisconnectResponse)message;
            cr = (CloseRequest)dr.context;
            if (cr != null) {
                cr.connection.closed = true;
                cr.connection.notifyInflightQos0(true);
                cr.getSender().tell(new CloseResponse(cr), this);
            }
        } else if (message instanceof ConnectionError) {
            ce = (ConnectionError)message;
            engineConnection = (EngineConnection)ce.channel.getContext();
            if (!engineConnection.closed) {
                if (engineConnection.timerPromise != null) {
                    tmp = engineConnection.timerPromise;
                    engineConnection.timerPromise = null;
                    this.timer.cancel(tmp);
                }
                engineConnection.notifyInflightQos0(true);
                engineConnection.closed = true;
                engineConnection.transport.close_tail();
                engineConnection.requestor.tell(new DisconnectNotification(engineConnection, ce.cause), this);
            }
        } else if (message instanceof PopResponse) {
            pr = (PopResponse)message;
            engineConnection = (EngineConnection)pr.promise.getContext();
            now = System.currentTimeMillis();
            timeout = engineConnection.transport.tick(now);
            Engine.logger.data(this, "onReceive", new Object[]{"Timeout: {}", timeout});
            if (timeout > 0L) {
                engineConnection.timerPromise = promise = new TimerPromiseImpl(this, engineConnection);
                Engine.logger.data(this, "onReceive", new Object[]{"Scheduling at: {}", timeout - now});
                this.timer.schedule(timeout - now, promise);
                this.writeToNetwork(engineConnection);
            }
        }
lbl232:
        // 19 sources

        Engine.logger.exit(this, "onReceive");
    }

    private void writeToNetwork(EngineConnection engineConnection) {
        String methodName = "writeToNetwork";
        logger.entry(this, "writeToNetwork", engineConnection);
        if (engineConnection.transport.pending() > 0) {
            ByteBuffer head = engineConnection.transport.head();
            int amount = head.remaining();
            engineConnection.channel.write(head, new NetworkWritePromiseImpl(this, amount, engineConnection));
            engineConnection.transport.pop(amount);
            engineConnection.transport.tick(System.currentTimeMillis());
        }
        logger.exit(this, "writeToNetwork");
    }

    private void resetReceiveIdleTimer(Event event) {
        int localIdleTimeOut;
        Transport transport;
        String methodName = "resetReceiveIdleTimer";
        logger.entry(this, "resetReceiveIdleTimer", event);
        if (this.receiveScheduledFuture != null) {
            this.receiveScheduledFuture.cancel(false);
        }
        if ((transport = event.getTransport()) != null && (localIdleTimeOut = transport.getIdleTimeout()) > 0) {
            Runnable receiveTimeout = new Runnable(){

                @Override
                public void run() {
                    String methodName = "run";
                    logger.entry(this, "run");
                    transport.process();
                    transport.tick(System.currentTimeMillis());
                    logger.exit("run");
                }
            };
            this.receiveScheduledFuture = this.scheduler.schedule(receiveTimeout, (long)localIdleTimeOut, TimeUnit.MILLISECONDS);
        }
        logger.exit(this, "resetReceiveIdleTimer");
    }

    private void process(Collector collector) {
        String methodName = "process";
        logger.entry(this, "process", collector);
        while (collector.peek() != null) {
            Event event = collector.peek();
            logger.data(this, "process", new Object[]{"Processing event: {}", event.getType()});
            event.dispatch(this);
            this.resetReceiveIdleTimer(event);
            collector.pop();
        }
        logger.exit(this, "process");
    }

    private void processEventConnectionRemoteState(Event event) {
        String methodName = "processEventConnectionRemoteState";
        logger.entry(this, "processEventConnectionRemoteState", event);
        if (event.getConnection().getRemoteState() == EndpointState.CLOSED) {
            ErrorCondition remoteCondition = event.getConnection().getRemoteCondition();
            EngineConnection engineConnection = (EngineConnection)event.getConnection().getContext();
            if (engineConnection.timerPromise != null) {
                TimerPromiseImpl tmp = engineConnection.timerPromise;
                engineConnection.timerPromise = null;
                this.timer.cancel(tmp);
            }
            if (event.getConnection().getLocalState() == EndpointState.CLOSED || engineConnection.openRequest == null) {
                if (!engineConnection.closed) {
                    engineConnection.notifyInflightQos0(true);
                    engineConnection.closed = true;
                    CloseRequest cr = engineConnection.closeRequest;
                    engineConnection.closeRequest = null;
                    NetworkClosePromiseImpl future = new NetworkClosePromiseImpl(this, cr);
                    engineConnection.channel.close(future);
                    if (cr == null) {
                        ClientException error = this.getClientException(remoteCondition);
                        engineConnection.requestor.tell(new DisconnectNotification(engineConnection, error), this);
                    }
                }
            } else {
                OpenRequest req = engineConnection.openRequest;
                engineConnection.openRequest = null;
                if (!engineConnection.closed) {
                    engineConnection.notifyInflightQos0(true);
                    engineConnection.closed = true;
                    engineConnection.channel.close(null);
                    Sasl sasl = engineConnection.transport.sasl();
                    ClientException clientException = sasl.getOutcome() == Sasl.SaslOutcome.PN_SASL_AUTH ? new SecurityException("Failed to authenticate with server - invalid username or password", this.getClientException(remoteCondition)) : (remoteCondition == null || remoteCondition.getDescription() == null ? new NetworkException("The server closed the connection without providing any error information.") : this.getClientException(remoteCondition));
                    req.getSender().tell(new OpenResponse(req, clientException), this);
                }
            }
        } else if (event.getConnection().getRemoteState() == EndpointState.ACTIVE) {
            EngineConnection engineConnection = (EngineConnection)event.getConnection().getContext();
            long now = System.currentTimeMillis();
            long timeout = engineConnection.transport.tick(now);
            if (timeout > 0L) {
                engineConnection.timerPromise = new TimerPromiseImpl(this, engineConnection);
                this.timer.schedule(timeout - now, engineConnection.timerPromise);
            }
        }
        logger.exit(this, "processEventConnectionRemoteState");
    }

    private ClientException getClientException(ErrorCondition errorCondition) {
        String methodName = "getClientException";
        logger.entry(this, "getClientException", errorCondition);
        ClientException result = null;
        if (errorCondition != null && errorCondition.getCondition() != null) {
            if (errorCondition.getCondition() == LinkError.STOLEN) {
                result = new ReplacedException(errorCondition.getDescription());
            } else if (errorCondition.getCondition().equals(AmqpError.PRECONDITION_FAILED) || errorCondition.getCondition().equals(AmqpError.NOT_ALLOWED) || errorCondition.getCondition().equals(AmqpError.NOT_IMPLEMENTED) || errorCondition.getDescription().contains("_InvalidSourceTimeout")) {
                result = new NotPermittedException(errorCondition.getDescription());
            }
            if (result == null && errorCondition.getDescription() != null && (errorCondition.getDescription().contains("sasl ") || errorCondition.getDescription().contains("SSL "))) {
                result = new SecurityException(errorCondition.getDescription());
            }
            if (result == null) {
                String msg = errorCondition.getCondition().toString();
                if (errorCondition.getDescription() != null) {
                    msg = msg + ": " + errorCondition.getDescription();
                }
                result = new NetworkException(msg);
            }
        }
        logger.exit(this, "getClientException", result);
        return result;
    }

    private void processEventLinkLocalState(Event event) {
        String methodName = "processEventLinkLocalState";
        logger.entry(this, "processEventLinkLocalState", event);
        Link link = event.getLink();
        logger.data(this, "processEventLinkLocalState", new Object[]{"LINK_LOCAL {} {} {}", link, link.getLocalState(), link.getRemoteState()});
        logger.exit(this, "processEventLinkLocalState");
    }

    private void processEventLinkRemoteState(Event event) {
        String methodName = "processEventLinkRemoteState";
        logger.entry(this, "processEventLinkRemoteState", event);
        Link link = event.getLink();
        logger.data(this, "processEventLinkRemoteState", new Object[]{"LINK_REMOTE {} {} {}", link, link.getLocalState(), link.getRemoteState()});
        Event.Type eventType = event.getType();
        if (link instanceof Receiver) {
            if (eventType == Event.Type.LINK_REMOTE_OPEN) {
                if (link.getLocalState() == EndpointState.ACTIVE) {
                    EngineConnection engineConnection = (EngineConnection)event.getConnection().getContext();
                    EngineConnection.SubscriptionData sd = engineConnection.subscriptionData.get(link.getName());
                    if (link.getRemoteState() == EndpointState.ACTIVE) {
                        sd.subscriber.tell(new SubscribeResponse(engineConnection, new SubscriptionTopic(link.getName())), this);
                    } else if (link.getRemoteState() == EndpointState.CLOSED) {
                        ClientException clientException = this.getClientException(link.getRemoteCondition());
                        logger.data(this, "processEventLinkRemoteState", event, clientException, this);
                        sd.subscriber.tell(new SubscribeResponse(engineConnection, new SubscriptionTopic(link.getName()), clientException), this);
                    }
                }
            } else if ((eventType == Event.Type.LINK_REMOTE_CLOSE || eventType == Event.Type.LINK_REMOTE_DETACH) && link.getRemoteState() == EndpointState.CLOSED) {
                ClientException clientException = this.getClientException(link.getRemoteCondition());
                if (link.getLocalState() != EndpointState.CLOSED && !link.detached()) {
                    if (clientException == null) {
                        clientException = new ClientException("The server indicated that the destination was unsubscribed due to an error condition, without providing any further error information.");
                    }
                    link.close();
                }
                link.free();
                EngineConnection engineConnection = (EngineConnection)event.getConnection().getContext();
                EngineConnection.SubscriptionData sd = engineConnection.subscriptionData.remove(link.getName());
                if (sd == null) {
                    logger.ffdc(this, "processEventLinkRemoteState", FFDCProbeId.PROBE_001, null, this, event);
                } else {
                    sd.subscriber.tell(new UnsubscribeResponse(engineConnection, new SubscriptionTopic(link.getName()), clientException), this);
                }
            }
        } else if (link instanceof Sender && eventType == Event.Type.LINK_REMOTE_CLOSE && link.getRemoteState() == EndpointState.CLOSED) {
            if (link.getLocalState() != EndpointState.CLOSED) {
                String msg = "The server indicated that our sending link was closed due to an error condition, ";
                ErrorCondition remoteCondition = link.getRemoteCondition();
                if (remoteCondition == null || remoteCondition.getCondition() == null) {
                    msg = msg + "without providing any further error information.";
                } else {
                    msg = msg + remoteCondition.getCondition().toString();
                    if (remoteCondition.getDescription() != null) {
                        msg = msg + " - " + remoteCondition.getDescription();
                    }
                }
                logger.data(this, "processEventLinkRemoteState", msg, link.getTarget().getAddress(), this);
                EngineConnection engineConnection = (EngineConnection)event.getConnection().getContext();
                for (Delivery delivery = link.head(); delivery != null; delivery = delivery.next()) {
                    SendRequest sr = engineConnection.inProgressOutboundDeliveries.remove(delivery);
                    if (sr == null || sr.getSender() == null) continue;
                    sr.getSender().tell(new SendResponse(sr, new ClientException(msg)), this);
                }
                link.close();
            }
            link.free();
        }
        logger.exit(this, "processEventLinkRemoteState");
    }

    private void processEventSessionRemoteState(Event event) {
        String methodName = "processEventSessionRemoteState";
        logger.entry(this, "processEventSessionRemoteState", event);
        if (event.getSession().getRemoteState() == EndpointState.ACTIVE) {
            if (event.getSession().getLocalState() == EndpointState.ACTIVE) {
                EngineConnection engineConnection = (EngineConnection)event.getConnection().getContext();
                if (!engineConnection.closed) {
                    OpenRequest req = engineConnection.openRequest;
                    engineConnection.openRequest = null;
                    engineConnection.requestor.tell(new OpenResponse(req, engineConnection), this);
                }
            } else {
                Connection protonConnection = event.getConnection();
                protonConnection.setCondition(new ErrorCondition(Symbol.getSymbol("mqlight:session-remote-open-rejected"), "MQ Light client is unable to accept an open session request"));
                protonConnection.close();
            }
        }
        logger.exit(this, "processEventSessionRemoteState");
    }

    @Override
    public void onConnectionInit(Event e) {
    }

    @Override
    public void onConnectionLocalOpen(Event e) {
    }

    @Override
    public void onConnectionRemoteOpen(Event e) {
        this.processEventConnectionRemoteState(e);
    }

    @Override
    public void onConnectionLocalClose(Event e) {
    }

    @Override
    public void onConnectionRemoteClose(Event e) {
        this.processEventConnectionRemoteState(e);
    }

    @Override
    public void onConnectionBound(Event e) {
    }

    @Override
    public void onConnectionUnbound(Event e) {
    }

    @Override
    public void onConnectionFinal(Event e) {
    }

    @Override
    public void onSessionInit(Event e) {
    }

    @Override
    public void onSessionLocalOpen(Event e) {
    }

    @Override
    public void onSessionRemoteOpen(Event e) {
        this.processEventSessionRemoteState(e);
    }

    @Override
    public void onSessionLocalClose(Event e) {
    }

    @Override
    public void onSessionRemoteClose(Event e) {
        this.processEventSessionRemoteState(e);
    }

    @Override
    public void onSessionFinal(Event e) {
    }

    @Override
    public void onLinkInit(Event e) {
    }

    @Override
    public void onLinkLocalOpen(Event e) {
        this.processEventLinkLocalState(e);
    }

    @Override
    public void onLinkRemoteOpen(Event e) {
        this.processEventLinkRemoteState(e);
    }

    @Override
    public void onLinkLocalDetach(Event e) {
        this.processEventLinkLocalState(e);
    }

    @Override
    public void onLinkRemoteDetach(Event e) {
        this.processEventLinkRemoteState(e);
    }

    @Override
    public void onLinkLocalClose(Event e) {
        this.processEventLinkLocalState(e);
    }

    @Override
    public void onLinkRemoteClose(Event e) {
        this.processEventLinkRemoteState(e);
    }

    @Override
    public void onLinkFlow(Event e) {
    }

    @Override
    public void onLinkFinal(Event e) {
    }

    @Override
    public void onDelivery(Event event) {
        String methodName = "onDelivery";
        logger.entry(this, "onDelivery", event);
        EngineConnection engineConnection = (EngineConnection)event.getConnection().getContext();
        Delivery delivery = event.getDelivery();
        if (event.getLink() instanceof Sender) {
            SendRequest sr = engineConnection.inProgressOutboundDeliveries.remove(delivery);
            Exception exception = null;
            if (delivery.getRemoteState() instanceof Rejected) {
                Rejected rejected = (Rejected)delivery.getRemoteState();
                ErrorCondition error = rejected.getError();
                exception = error == null || error.getDescription() == null ? new Exception("Message was rejected") : new Exception(error.getDescription());
            } else if (delivery.getRemoteState() instanceof Released) {
                exception = new Exception("Message was released");
            } else if (delivery.getRemoteState() instanceof Modified) {
                exception = new Exception("Message was modified");
            }
            if (!sr.retainLink) {
                event.getLink().close();
                event.getLink().free();
            }
            sr.getSender().tell(new SendResponse(sr, exception), this);
        } else if (delivery.isReadable() && !delivery.isPartial()) {
            Receiver receiver = (Receiver)event.getLink();
            int amount = delivery.pending();
            byte[] data = new byte[amount];
            receiver.recv(data, 0, amount);
            receiver.advance();
            EngineConnection.SubscriptionData subData = engineConnection.subscriptionData.get(event.getLink().getName());
            ++subData.unsettled;
            QOS qos = delivery.remotelySettled() ? QOS.AT_MOST_ONCE : QOS.AT_LEAST_ONCE;
            subData.subscriber.tell(new DeliveryRequest(data, qos, event.getLink().getName(), delivery, event.getConnection()), this);
        }
        logger.exit(this, "onDelivery");
    }

    @Override
    public void onTransport(Event e) {
    }

    @Override
    public void onTransportError(Event e) {
    }

    @Override
    public void onTransportHeadClosed(Event e) {
    }

    @Override
    public void onTransportTailClosed(Event e) {
    }

    @Override
    public void onTransportClosed(Event e) {
    }

    @Override
    public void onUnhandled(Event e) {
        IllegalStateException exception = new IllegalStateException("Unknown event type: " + (Object)((Object)e.getType()));
        logger.throwing(this, "onUnhandled", exception);
        throw exception;
    }

    public static Handler getHandler(Record r) {
        return r.get(Handler.class, Handler.class);
    }

    public static void setHandler(Record r, Handler handler) {
        r.set(Handler.class, Handler.class, handler);
    }

    public static Handler getHandler(Extendable ext) {
        return ext.attachments().get(Handler.class, Handler.class);
    }

    public static void setHandler(Extendable ext, Handler handler) {
        ext.attachments().set(Handler.class, Handler.class, handler);
    }

    @Override
    public void onReactorInit(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onReactorQuiesced(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onReactorFinal(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onTimerTask(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onSelectableInit(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onSelectableUpdated(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onSelectableReadable(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onSelectableWritable(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onSelectableExpired(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onSelectableError(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void onSelectableFinal(Event e) {
        this.onUnhandled(e);
    }

    @Override
    public void add(Handler child) {
        this.children.add(child);
    }

    @Override
    public Iterator<Handler> children() {
        return this.children.iterator();
    }

    static class EngineProtocolTracer
    implements ProtocolTracer {
        private static final Logger logger = LoggerFactory.getLogger(EngineProtocolTracer.class);
        final String clientId;

        public EngineProtocolTracer(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public void receivedFrame(TransportFrame transportFrame) {
            logger.data("receivedFrame", this.clientId, transportFrame);
        }

        @Override
        public void sentFrame(TransportFrame transportFrame) {
            logger.data("sentFrame", this.clientId, transportFrame);
        }
    }
}

